/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.ExcludeGroup;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.group.ItemGroupManager;
import xyz.alexcrea.cuanvil.gui.config.global.GroupConfigGui;

public class MaterialGroupApi {
    private static Object saveChangeTask = null;
    private static Object reloadChangeTask = null;

    private MaterialGroupApi() {
    }

    public static boolean addMaterialGroup(@NotNull AbstractMaterialGroup group) {
        return MaterialGroupApi.addMaterialGroup(group, false);
    }

    public static boolean addMaterialGroup(@NotNull AbstractMaterialGroup group, boolean overrideDeleted) {
        ItemGroupManager itemGroupManager = ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager();
        if (!overrideDeleted && ConfigHolder.ITEM_GROUP_HOLDER.isDeleted(group.getName())) {
            return false;
        }
        if (itemGroupManager.get(group.getName()) != null) {
            return false;
        }
        itemGroupManager.getGroupMap().put(group.getName(), group);
        if (!MaterialGroupApi.writeMaterialGroup(group, false)) {
            return false;
        }
        if (group instanceof IncludeGroup) {
            IncludeGroup includeGroup = (IncludeGroup)group;
            GroupConfigGui configGui = GroupConfigGui.getCurrentInstance();
            if (configGui != null) {
                configGui.updateValueForGeneric(includeGroup, true);
            }
        }
        if (ConfigOptions.INSTANCE.getVerboseDebugLog()) {
            CustomAnvil.instance.getLogger().info("Registered group " + group.getName());
        }
        return true;
    }

    public static boolean writeMaterialGroup(@NotNull AbstractMaterialGroup group) {
        return MaterialGroupApi.writeMaterialGroup(group, true);
    }

    public static boolean writeMaterialGroup(@NotNull AbstractMaterialGroup group, boolean updatePlanned) {
        boolean changed;
        String name = group.getName();
        if (name.contains(".")) {
            CustomAnvil.instance.getLogger().warning("Group " + name + " contain . in its name but should not. this material group is ignored.");
            return false;
        }
        if (group instanceof IncludeGroup) {
            IncludeGroup includeGroup = (IncludeGroup)group;
            changed = MaterialGroupApi.writeKnownGroup("include", includeGroup);
        } else {
            if (group instanceof ExcludeGroup) {
                ExcludeGroup excludeGroup = (ExcludeGroup)group;
                throw new UnsupportedOperationException("exclude group is temporarily disable for the time being. sorry");
            }
            changed = MaterialGroupApi.writeUnknownGroup(group);
        }
        if (!changed) {
            return false;
        }
        MaterialGroupApi.prepareSaveTask();
        if (updatePlanned) {
            MaterialGroupApi.prepareUpdateTask();
        }
        return true;
    }

    private static boolean writeKnownGroup(@NotNull String groupType, @NotNull AbstractMaterialGroup group) {
        FileConfiguration config = ConfigHolder.ITEM_GROUP_HOLDER.getConfig();
        String basePath = group.getName() + ".";
        EnumSet<Material> materialSet = group.getNonGroupInheritedMaterials();
        Set<AbstractMaterialGroup> groupSet = group.getGroups();
        boolean empty = true;
        if (!materialSet.isEmpty()) {
            config.set(basePath + "items", MaterialGroupApi.materialSetToStringList(materialSet));
            empty = false;
        } else {
            config.set(basePath + "items", null);
        }
        if (!groupSet.isEmpty()) {
            config.set(basePath + "groups", MaterialGroupApi.materialGroupSetToStringList(groupSet));
            empty = false;
        } else {
            config.set(basePath + "groups", null);
        }
        if (empty) {
            config.set(basePath + "type", null);
            return false;
        }
        config.set(basePath + "type", (Object)groupType);
        return true;
    }

    private static boolean writeUnknownGroup(@NotNull AbstractMaterialGroup group) {
        FileConfiguration config = ConfigHolder.ITEM_GROUP_HOLDER.getConfig();
        String basePath = group.getName() + ".";
        EnumSet<Material> materials = group.getMaterials();
        if (materials.isEmpty()) {
            return false;
        }
        config.set(basePath + "type", (Object)"include");
        config.set(basePath + "items", MaterialGroupApi.materialSetToStringList(materials));
        return true;
    }

    public static List<String> materialSetToStringList(@NotNull Set<Material> materials) {
        return materials.stream().map(material -> material.getKey().getKey().toLowerCase()).toList();
    }

    public static List<String> materialGroupSetToStringList(@NotNull Set<AbstractMaterialGroup> groups2) {
        return groups2.stream().map(AbstractMaterialGroup::getName).toList();
    }

    public static boolean removeGroup(@NotNull AbstractMaterialGroup group) {
        AbstractMaterialGroup removed = (AbstractMaterialGroup)ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().groupMap.remove(group.getName());
        if (removed == null) {
            return false;
        }
        ConfigHolder.ITEM_GROUP_HOLDER.delete(group.getName());
        MaterialGroupApi.prepareSaveTask();
        if (group instanceof IncludeGroup) {
            IncludeGroup includeGroup = (IncludeGroup)group;
            GroupConfigGui configGui = GroupConfigGui.getCurrentInstance();
            if (configGui != null) {
                configGui.removeGeneric(includeGroup);
            }
        }
        return true;
    }

    private static void prepareSaveTask() {
        if (saveChangeTask != null) {
            return;
        }
        saveChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.ITEM_GROUP_HOLDER.saveToDisk(true);
            saveChangeTask = null;
        });
    }

    private static void prepareUpdateTask() {
        if (reloadChangeTask != null) {
            return;
        }
        reloadChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.ITEM_GROUP_HOLDER.reload();
            GroupConfigGui configGui = GroupConfigGui.getCurrentInstance();
            if (configGui != null) {
                configGui.reloadValues();
            }
            reloadChangeTask = null;
        });
    }

    @Nullable
    public static AbstractMaterialGroup getGroup(@NotNull String groupName) {
        return ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().get(groupName);
    }

    @NotNull
    public static Map<String, AbstractMaterialGroup> getRegisteredGroups() {
        return Collections.unmodifiableMap(ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().getGroupMap());
    }
}

