/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.AbstractSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class EnumSettingGui<T extends Enum<T>>
extends AbstractSettingGui {
    private final EnumSettingFactory<T> holder;
    private final T before;
    private T now;
    protected GuiItem returnToDefault;

    protected EnumSettingGui(EnumSettingFactory<T> holder, T now) {
        super(3, holder.getTitle(), holder.parent);
        this.holder = holder;
        this.before = now;
        this.now = now;
        this.prepareStaticItems();
        this.updateValueDisplay();
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern("000000000", "D000v0000", "B0000000S");
    }

    public void prepareStaticItems() {
        this.prepareReturnToDefault();
    }

    protected void prepareReturnToDefault() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Collections.singletonList("\u00a77Default value is \u00a7e" + ((ConfigurableEnum)this.holder.getDefault()).configurationGuiName()));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.now = this.holder.getDefault();
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    protected void updateValueDisplay() {
        PatternPane pane = this.getPane();
        ItemStack displayedItem = ((ConfigurableEnum)this.now).configurationGuiItem();
        GuiItem resultItem = new GuiItem(displayedItem, this.selectNext(), (Plugin)CustomAnvil.instance);
        pane.bindItem('v', resultItem);
        GuiItem returnToDefault = this.now != this.holder.getDefault() ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    protected Consumer<InventoryClickEvent> selectNext() {
        return event -> {
            event.setCancelled(true);
            this.now = this.holder.next(this.now);
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    public boolean onSave() {
        this.holder.config.getConfig().set(this.holder.configPath, (Object)((ConfigurableEnum)this.now).configName());
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        return !((Enum)this.now).equals(this.before);
    }

    public static abstract class EnumSettingFactory<T extends Enum<T>>
    extends AbstractSettingGui.SettingGuiFactory {
        @NotNull
        String title;
        @NotNull
        ValueUpdatableGui parent;

        protected EnumSettingFactory(@NotNull String title, @NotNull ValueUpdatableGui parent, @NotNull String configPath, @NotNull ConfigHolder config) {
            super(configPath, config);
            this.title = title;
            this.parent = parent;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        @NotNull
        public abstract T getConfiguredValue();

        @NotNull
        public abstract List<String> getDisplayLore(T var1);

        @NotNull
        public T next(@NotNull T now) {
            Class clazz = ((Enum)now).getDeclaringClass();
            Enum[] values2 = (Enum[])clazz.getEnumConstants();
            int index = ((Enum)now).ordinal();
            if (index == values2.length - 1) {
                return (T)values2[0];
            }
            return (T)values2[index + 1];
        }

        @NotNull
        public abstract T getDefault();

        @Override
        public Gui create() {
            T now = this.getConfiguredValue();
            return new EnumSettingGui<T>(this, now);
        }

        public GuiItem getItem(@NotNull Material material, @NotNull String name) {
            T value = this.getConfiguredValue();
            ItemStack item = new ItemStack(material);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName(name);
            meta.setLore(this.getDisplayLore(value));
            meta.addItemFlags(ItemFlag.values());
            item.setItemMeta(meta);
            return GuiGlobalItems.openSettingGuiItem(item, this);
        }
    }

    public static interface ConfigurableEnum {
        public String configName();

        public ItemStack configurationGuiItem();

        public String configurationGuiName();
    }
}

