/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks;

import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import dev.terminalmc.moremousetweaks.util.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class MoreMouseTweaks {
    public static final String MOD_ID = "moremousetweaks";
    public static final String MOD_NAME = "MoreMouseTweaks";
    public static final ModLogger LOG = new ModLogger("MoreMouseTweaks");
    public static volatile int lastUpdatedSlot = -1;

    public static void init() {
        Config.getAndSave();
    }

    public static void afterConfigSaved(Config config) {
        @Nullable Minecraft mc = Minecraft.getInstance();
        Config.Options options = config.options;
        if (mc != null) {
            MoreMouseTweaks.setInteractionManagerTickRate(options);
            if (mc.getConnection() != null && mc.getConnection().isAcceptingMessages()) {
                MoreMouseTweaks.updateItemTags(options);
            }
        }
    }

    public static void setInteractionManagerTickRate(Config.Options options) {
        if (Minecraft.getInstance().getSingleplayerServer() == null) {
            InteractionManager.setTickRate(options.interactionIntervalMp);
        } else {
            InteractionManager.setTickRate(options.interactionIntervalSp);
        }
    }

    public static void updateItemTags(Config.Options options) {
        options.typeMatchItemCache.clear();
        BuiltInRegistries.ITEM.getTags().forEach(named -> {
            if (options.typeMatchTags.contains(named.key().location().getPath())) {
                named.forEach(itemHolder -> options.typeMatchItemCache.add((Item)itemHolder.value()));
            }
        });
    }
}

