/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.inventory;

import dev.terminalmc.moremousetweaks.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.moremousetweaks.inventory.helper.ComparisonHelper;
import dev.terminalmc.moremousetweaks.inventory.helper.ScopeHelper;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import dev.terminalmc.moremousetweaks.util.InputUtil;
import dev.terminalmc.moremousetweaks.util.KeyUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import yalter.mousetweaks.MouseButton;

public class ClickHandler {
    public static boolean handleSlotClick(Slot slot, int button, ClickConsumer clickConsumer, Supplier<List<Slot>> slotSupplier) {
        if (button != MouseButton.LEFT.getValue()) {
            return false;
        }
        if (KeyUtil.hasShiftDown()) {
            return false;
        }
        if (ItemLocksWrapper.isLocked(slot)) {
            return false;
        }
        if (InputUtil.isMatchingSlotsKeyDown()) {
            ClickHandler.handleMatchingSlotsClick(slot, clickConsumer, slotSupplier);
            return true;
        }
        if (InputUtil.isDropKeyDown()) {
            clickConsumer.call(slot, MouseButton.RIGHT.getValue(), ClickType.THROW);
            return true;
        }
        return false;
    }

    private static void handleMatchingSlotsClick(Slot slot, ClickConsumer original, Supplier<List<Slot>> slotSupplier) {
        int button = InputUtil.isDropKeyDown() ? MouseButton.RIGHT.getValue() : MouseButton.LEFT.getValue();
        ClickType clickType = InputUtil.isDropKeyDown() ? ClickType.THROW : ClickType.QUICK_MOVE;
        ItemStack stack = slot.getItem().copy();
        original.call(slot, button, clickType);
        for (Slot slot2 : ScopeHelper.collectSlots(slot, slotSupplier.get())) {
            if (slot2 == slot || !slot2.mayPickup((Player)Minecraft.getInstance().player) || slot2.container != slot.container || !slot2.hasItem() || !ComparisonHelper.itemMatches(stack, slot2.getItem())) continue;
            InteractionManager.pushCallbackEvent(() -> {
                original.call(slot2, button, clickType);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @FunctionalInterface
    public static interface ClickConsumer {
        public void call(Slot var1, int var2, ClickType var3);
    }
}

