/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.inventory.screen;

import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.inventory.screen.CreativeContainerScreenHelper;
import dev.terminalmc.moremousetweaks.inventory.util.Scope;
import dev.terminalmc.moremousetweaks.util.inject.ISlot;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class ContainerScreenHelper<T extends AbstractContainerScreen<?>> {
    protected final T screen;

    protected ContainerScreenHelper(T screen) {
        this.screen = screen;
    }

    public static <T extends AbstractContainerScreen<?>> ContainerScreenHelper<T> of(T screen) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return new CreativeContainerScreenHelper<CreativeModeInventoryScreen>((CreativeModeInventoryScreen)screen);
        }
        return new ContainerScreenHelper<T>(screen);
    }

    public boolean isHotbarSlot(Slot slot) {
        return ((ISlot)slot).mmt$getIndexInInv() < 9;
    }

    public boolean isExtraSlot(Slot slot) {
        return ((ISlot)slot).mmt$getIndexInInv() > 35;
    }

    public Scope getScope(Slot slot) {
        if (this.screen instanceof AbstractContainerScreen) {
            if (slot.container instanceof Inventory) {
                boolean mergeWithHotbar = false;
                if (this.isExtraSlot(slot)) {
                    switch (Config.options().extraSlotScope) {
                        case HOTBAR: {
                            mergeWithHotbar = true;
                            break;
                        }
                        case EXTRA: {
                            return Scope.PLAYER_INV_EXTRA;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                if (mergeWithHotbar || this.isHotbarSlot(slot)) {
                    switch (Config.options().hotbarScope) {
                        case HOTBAR: {
                            return Scope.PLAYER_INV_HOTBAR;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                return Scope.PLAYER_INV;
            }
            return Scope.PLAYER_OTHER;
        }
        if (slot.container instanceof Inventory) {
            if (this.isHotbarSlot(slot)) {
                switch (Config.options().hotbarScope) {
                    case HOTBAR: {
                        return Scope.PLAYER_INV_HOTBAR;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            return Scope.PLAYER_INV;
        }
        return Scope.CONTAINER_INV;
    }
}

