/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.mixin.event;

import dev.terminalmc.moremousetweaks.MoreMouseTweaks;
import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Inject(method={"handleLogin"}, at={@At(value="RETURN")})
    private void afterLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        MoreMouseTweaks.setInteractionManagerTickRate(Config.options());
        MoreMouseTweaks.updateItemTags(Config.options());
    }

    @Inject(method={"handleSetCursorItem"}, at={@At(value="HEAD")})
    public void beforeHeldItemChange(ClientboundSetCursorItemPacket packet, CallbackInfo ci) {
        InteractionManager.triggerSend(InteractionManager.TriggerType.HELD_ITEM_CHANGE);
    }

    @Inject(method={"handleContainerSetSlot"}, at={@At(value="RETURN")})
    public void afterSlotItemChange(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
        MoreMouseTweaks.lastUpdatedSlot = packet.getSlot();
        InteractionManager.triggerSend(InteractionManager.TriggerType.CONTAINER_SLOT_UPDATE);
    }
}

