/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.mixin.quick.craft;

import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.inventory.helper.InteractionHelper;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import dev.terminalmc.moremousetweaks.util.InputUtil;
import dev.terminalmc.moremousetweaks.util.KeyUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yalter.mousetweaks.MouseButton;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookComponentMixin {
    @Shadow
    public static final int IMAGE_WIDTH = 147;
    @Shadow
    public static final int IMAGE_HEIGHT = 166;
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;
    @Shadow
    private int width;
    @Shadow
    private int xOffset;
    @Shadow
    private int height;
    @Shadow
    private boolean ignoreTextInput;
    @Shadow
    protected Minecraft minecraft;
    @Shadow
    @Final
    protected RecipeBookMenu menu;

    @Shadow
    public abstract boolean isVisible();

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/recipebook/RecipeBookComponent;isOffsetNextToMainGUI()Z", shift=At.Shift.AFTER)})
    public void mouseClicked(MouseButtonEvent event, boolean isDoubleClick, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.options().useQuickCrafting || event.button() != MouseButton.RIGHT.getValue()) {
            return;
        }
        int resultSlotId = this.mmt$getResultSlotIndex(this.menu);
        if (event.hasShiftDown() && InputUtil.isMatchingSlotsKeyDown()) {
            this.mmt$bulkQuickCraft(resultSlotId, false);
        } else {
            this.mmt$quickCraft(resultSlotId);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return;
        }
        if (!Config.options().useQuickCrafting || !this.minecraft.options.keyDrop.matches(event)) {
            return;
        }
        if (!this.minecraft.player.containerMenu.getCarried().isEmpty()) {
            return;
        }
        this.ignoreTextInput = false;
        boolean clickSuccess = this.recipeBookPage.mouseClicked(new MouseButtonEvent(InputUtil.getMouseX(), InputUtil.getMouseY(), new MouseButtonInfo(MouseButton.LEFT.getValue(), 0)), (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166, false);
        if (!clickSuccess) {
            return;
        }
        RecipeDisplayId recipe = this.recipeBookPage.getLastClickedRecipe();
        RecipeCollection collection = this.recipeBookPage.getLastClickedRecipeCollection();
        if (recipe == null || collection == null) {
            return;
        }
        int resultSlotId = this.mmt$getResultSlotIndex(this.menu);
        InteractionManager.pushPacketEvent(new ServerboundPlaceRecipePacket(this.menu.containerId, recipe, event.hasShiftDown()), InteractionManager.TICK_WAITER);
        if (event.hasShiftDown() && InputUtil.isMatchingSlotsKeyDown()) {
            this.mmt$bulkQuickCraft(resultSlotId, true);
        } else if (event.hasShiftDown()) {
            this.mmt$dropAll(resultSlotId);
        } else {
            InteractionHelper.drop(this.menu.containerId, resultSlotId);
        }
        cir.setReturnValue((Object)true);
    }

    @Unique
    private void mmt$bulkQuickCraft(int resultSlotId, boolean drop) {
        RecipeDisplayId recipe = this.recipeBookPage.getLastClickedRecipe();
        RecipeCollection collection = this.recipeBookPage.getLastClickedRecipeCollection();
        if (recipe == null || collection == null) {
            return;
        }
        int maxOps = 0;
        for (Slot slot : this.minecraft.player.containerMenu.slots) {
            if (!slot.hasItem()) continue;
            ++maxOps;
        }
        AtomicBoolean abort = new AtomicBoolean(false);
        for (int i = 0; i < maxOps && !abort.get(); ++i) {
            InteractionManager.pushPacketEvent(new ServerboundPlaceRecipePacket(this.menu.containerId, recipe, true), type -> {
                if (!collection.isCraftable(recipe)) {
                    abort.set(true);
                    InteractionManager.clear();
                    return false;
                }
                return true;
            });
            if (drop) {
                this.mmt$dropAll(resultSlotId);
                continue;
            }
            InteractionHelper.quickMove(this.menu.containerId, resultSlotId);
        }
    }

    @Unique
    private void mmt$quickCraft(int resultSlotId) {
        boolean pickupClick = false;
        boolean quickMoveClick = false;
        if (KeyUtil.hasShiftDown()) {
            quickMoveClick = true;
        } else {
            switch (Config.options().qcSingleCraftMode) {
                case CURSOR: {
                    pickupClick = true;
                    break;
                }
                case CURSOR_INVENTORY: {
                    pickupClick = true;
                    quickMoveClick = true;
                    break;
                }
                case INVENTORY: {
                    quickMoveClick = true;
                }
            }
        }
        if (pickupClick) {
            InteractionHelper.pickup(this.menu.containerId, resultSlotId);
        }
        if (quickMoveClick) {
            InteractionHelper.quickMove(this.menu.containerId, resultSlotId);
        }
    }

    @Unique
    private void mmt$dropAll(int resSlot) {
        int maxOps = this.mmt$getBiggestCraftingStackSize();
        for (int i = 0; i < maxOps; ++i) {
            InteractionHelper.drop(this.menu.containerId, resSlot);
        }
    }

    @Unique
    private int mmt$getResultSlotIndex(RecipeBookMenu menu) {
        RecipeBookMenu recipeBookMenu = menu;
        Objects.requireNonNull(recipeBookMenu);
        RecipeBookMenu recipeBookMenu2 = recipeBookMenu;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractCraftingMenu.class, AbstractFurnaceMenu.class}, (Object)recipeBookMenu2, n)) {
            case 0 -> {
                AbstractCraftingMenu m = (AbstractCraftingMenu)recipeBookMenu2;
                yield m.getResultSlot().index;
            }
            case 1 -> {
                AbstractFurnaceMenu m = (AbstractFurnaceMenu)recipeBookMenu2;
                yield m.getResultSlot().index;
            }
            default -> 0;
        };
    }

    @Unique
    public Collection<Slot> mmt$getInputSlots() {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof AbstractCraftingMenu) {
            AbstractCraftingMenu m = (AbstractCraftingMenu)recipeBookMenu;
            return m.getInputGridSlots();
        }
        return List.of();
    }

    @Unique
    private int mmt$getBiggestCraftingStackSize() {
        int max = 0;
        for (Slot slot : this.mmt$getInputSlots()) {
            max = Math.max(max, slot.getItem().getCount());
        }
        return max;
    }
}

