/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.mixin.quick.trade;

import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.inventory.helper.ComparisonHelper;
import dev.terminalmc.moremousetweaks.inventory.helper.InteractionHelper;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import dev.terminalmc.moremousetweaks.util.InputUtil;
import dev.terminalmc.moremousetweaks.util.KeyUtil;
import dev.terminalmc.moremousetweaks.util.inject.IMerchantMenu;
import dev.terminalmc.moremousetweaks.util.inject.IMerchantScreen;
import dev.terminalmc.moremousetweaks.util.inject.ISpecialClickableButtonWidget;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import yalter.mousetweaks.MouseButton;

@Mixin(targets={"net/minecraft/client/gui/screens/inventory/MerchantScreen$TradeOfferButton"})
public class TradeOfferButtonMixin
implements ISpecialClickableButtonWidget {
    @Shadow
    @Final
    int index;
    @Unique
    private AbstractContainerScreen<?> mmt$containerScreen;
    @Unique
    private MerchantScreen mmt$merchantScreen;
    @Unique
    private IMerchantScreen mmt$iMerchantScreen;
    @Unique
    private MerchantMenu mmt$merchantMenu;
    @Unique
    private IMerchantMenu mmt$iMerchantMenu;

    @Override
    public boolean mmt$mouseClicked(int mouseButton) {
        if (!Config.options().useQuickTrading || mouseButton != MouseButton.RIGHT.getValue()) {
            return false;
        }
        Screen screen = Minecraft.getInstance().screen;
        boolean allCast = false;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen cs;
            this.mmt$containerScreen = cs = (AbstractContainerScreen)screen;
            if (cs instanceof MerchantScreen) {
                MerchantScreen ms;
                this.mmt$merchantScreen = ms = (MerchantScreen)cs;
                if (ms instanceof IMerchantScreen) {
                    IMerchantScreen ims;
                    this.mmt$iMerchantScreen = ims = (IMerchantScreen)ms;
                    AbstractContainerMenu abstractContainerMenu = cs.getMenu();
                    if (abstractContainerMenu instanceof MerchantMenu) {
                        MerchantMenu mm;
                        this.mmt$merchantMenu = mm = (MerchantMenu)abstractContainerMenu;
                        if (mm instanceof IMerchantMenu) {
                            IMerchantMenu imm;
                            this.mmt$iMerchantMenu = imm = (IMerchantMenu)mm;
                            allCast = true;
                        }
                    }
                }
            }
        }
        if (!allCast) {
            return false;
        }
        int offerId = this.index + this.mmt$iMerchantScreen.mmt$getOfferIdOffset();
        this.mmt$iMerchantScreen.mmt$setOfferId(offerId);
        this.mmt$iMerchantScreen.mmt$syncOfferId();
        if (KeyUtil.hasShiftDown() && InputUtil.isMatchingSlotsKeyDown()) {
            this.mmt$bulkQuickTrade(offerId);
        } else {
            InteractionHelper.pickup(this.mmt$merchantMenu.containerId, this.mmt$iMerchantMenu.mmt$getResultSlot());
        }
        return true;
    }

    @Unique
    private void mmt$bulkQuickTrade(int offerId) {
        MerchantOffer offer = this.mmt$iMerchantMenu.mmt$getOffer(offerId);
        int containerId = this.mmt$merchantMenu.containerId;
        int resultSlotId = this.mmt$iMerchantMenu.mmt$getResultSlot();
        int maxOps = 0;
        for (Slot slot : Minecraft.getInstance().player.containerMenu.slots) {
            if (!slot.hasItem()) continue;
            ++maxOps;
        }
        AtomicBoolean abort = new AtomicBoolean(false);
        for (int i = 0; i < maxOps && !abort.get(); ++i) {
            InteractionManager.pushCallbackEvent(() -> {
                this.mmt$iMerchantScreen.mmt$setOfferId(offerId);
                this.mmt$iMerchantScreen.mmt$syncOfferId();
                if (!this.mmt$canBuy(offer)) {
                    abort.set(true);
                    InteractionManager.clear();
                }
                return InteractionManager.TICK_WAITER;
            });
            InteractionHelper.quickMove(containerId, resultSlotId);
        }
    }

    @Unique
    private boolean mmt$canBuy(MerchantOffer offer) {
        if (offer.isOutOfStock()) {
            return false;
        }
        ItemCost costA = offer.getItemCostA();
        if (!ComparisonHelper.playerHas(costA.itemStack(), costA.count())) {
            return false;
        }
        Optional costB = offer.getItemCostB();
        return costB.isEmpty() || ComparisonHelper.playerHas(((ItemCost)costB.get()).itemStack(), ((ItemCost)costB.get()).count());
    }
}

