/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import dev.terminalmc.moremousetweaks.config.Config;
import net.minecraft.client.Minecraft;

public class InputUtil {
    public static double getMouseX() {
        Minecraft mc = Minecraft.getInstance();
        return mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
    }

    public static double getMouseY() {
        Minecraft mc = Minecraft.getInstance();
        return mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
    }

    private static Window window() {
        return Minecraft.getInstance().getWindow();
    }

    public static boolean isAnyKeyDown() {
        return InputUtil.isAnyKeyDown(InputUtil.window());
    }

    public static boolean isAnyKeyDown(Window window) {
        return InputUtil.isDropKeyDown(window) || InputUtil.isMatchingSlotsKeyDown(window);
    }

    public static boolean isDropKeyDown() {
        return InputUtil.isDropKeyDown(InputUtil.window());
    }

    public static boolean isDropKeyDown(Window window) {
        return Config.options().dropKey != -1 && InputConstants.isKeyDown((Window)window, (int)Config.options().dropKey);
    }

    public static boolean isMatchingSlotsKeyDown() {
        return InputUtil.isMatchingSlotsKeyDown(InputUtil.window());
    }

    public static boolean isMatchingSlotsKeyDown(Window window) {
        return Config.options().matchingSlotsKey != -1 && InputConstants.isKeyDown((Window)window, (int)Config.options().matchingSlotsKey);
    }
}

