/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.Optional;
import java.util.Set;
import mc.quackedducks.entities.QuackEntityTypes;
import mc.quackedducks.items.QuackyModItems;
import mc.quackedducks.sound.QuackedSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class QuackMod {
    public static final String MOD_ID = "quack";
    public static final Logger LOGGER = LogManager.getLogger((String)"quack");
    private static final Set<ResourceLocation> DUCK_BIOMES = Set.of(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"sunflower_plains"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"flower_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"birch_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dark_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_birch_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"meadow"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cherry_grove"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"swamp"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mangrove_swamp"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"river"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"frozen_river"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"beach"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_beach"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stony_shore"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"snowy_taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_pine_taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"old_growth_spruce_taiga"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"savanna"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"savanna_plateau"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_forest"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"windswept_hills"));

    public static void init() {
        LOGGER.info("QuackMod initialized!");
        QuackEntityTypes.init();
        QuackedSounds.init();
        QuackyModItems.init();
        BiomeModifications.addProperties((ctx, props) -> {
            Optional keyOpt = ctx.getKey();
            if (keyOpt.isEmpty()) {
                return;
            }
            ResourceLocation key = (ResourceLocation)keyOpt.get();
            if (!DUCK_BIOMES.contains(key)) {
                return;
            }
            boolean veryWet = key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"river")) || key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"frozen_river")) || key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"swamp")) || key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mangrove_swamp")) || key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"beach")) || key.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stony_shore"));
            int weight = veryWet ? 24 : 12;
            props.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)QuackEntityTypes.DUCK.get(), 3, 5), weight);
        });
    }
}

