/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import mc.quackedducks.entities.QuackEntityTypes;
import mc.quackedducks.entities.ai.FollowLeaderIfFreeGoal;
import mc.quackedducks.entities.ai.LayEggGoal;
import mc.quackedducks.entities.ai.LeaderMigrationGoal;
import mc.quackedducks.items.QuackyModItems;
import mc.quackedducks.sound.QuackedSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DuckEntity
extends TamableAnimal
implements GeoEntity {
    @Nullable
    private DuckEntity following;
    @Nullable
    private DuckEntity followedBy;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.duck.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.duck.walk");
    private static final RawAnimation PECK = RawAnimation.begin().then("animation.duck.peck", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHAKE = RawAnimation.begin().then("animation.duck.shake", Animation.LoopType.PLAY_ONCE);
    private FollowOwnerGoal followOwnerGoal;
    private static final int OWNER_FOLLOW_PRIORITY = 7;
    private boolean ownerFollowPaused = false;
    private boolean followGoalAdded = false;
    private int headStableTicks = 0;
    private static final int HEAD_STABLE_REQUIRED = 120;
    private static final float OWNER_ENABLE_DIST = 12.0f;
    private static final Logger LOG = LogUtils.getLogger();
    private static final boolean DEBUG_DUCKS = false;
    private DuckState animState = DuckState.IDLE;
    private DuckState lastLoggedState = null;
    private int idleVariantCooldown = 10;
    private int oneShotLockTicks = 0;
    private RawAnimation currentOneShot = null;
    private int lastTickSeen = -1;
    private static final double FOLLOWER_SPEED = 1.1;
    private static final double LEADER_MIGRATE_SPEED = 1.12;
    private static final double AMBIENT_STROLL_SPEED = 1.08;
    private static final Ingredient DUCK_FOOD = Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS, Items.BEETROOT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.TORCHFLOWER_SEEDS});

    public DuckEntity(EntityType<? extends DuckEntity> type, Level level) {
        super(type, level);
    }

    public boolean isFood(ItemStack stack) {
        return DUCK_FOOD.test(stack);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return (AgeableMob)((EntityType)QuackEntityTypes.DUCK.get()).create((Level)level, EntitySpawnReason.BREEDING);
    }

    public boolean hasFollower() {
        return this.followedBy != null && this.followedBy.isAlive() && !this.followedBy.isRemoved() && this.followedBy.getLeader() == this;
    }

    @Nullable
    public DuckEntity getLeader() {
        return this.following;
    }

    public boolean claimFollower(DuckEntity duck) {
        if (this.isBaby() || duck == null || duck.isBaby()) {
            return false;
        }
        if (this.followedBy == null || !this.followedBy.isAlive()) {
            this.followedBy = duck;
            return true;
        }
        return false;
    }

    public void releaseFollower(DuckEntity duck) {
        if (this.followedBy == duck) {
            this.followedBy = null;
        }
    }

    public void setLeader(@Nullable DuckEntity newLeader) {
        if (this.isBaby()) {
            return;
        }
        if (newLeader != null && newLeader.isBaby()) {
            return;
        }
        DuckEntity prev = this.following;
        this.following = newLeader;
        this.headStableTicks = 0;
        this.dbg("leader set: {} -> {}", prev == null ? "null" : Integer.valueOf(prev.getId()), newLeader == null ? "null" : Integer.valueOf(newLeader.getId()));
        this.updateOwnerFollowGoal();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("main", 2, state -> {
            boolean fastEnough;
            int tickDelta;
            int tickNow = this.tickCount;
            if (this.lastTickSeen < 0) {
                this.lastTickSeen = tickNow;
            }
            if ((tickDelta = tickNow - this.lastTickSeen) > 0) {
                if (this.oneShotLockTicks > 0) {
                    this.oneShotLockTicks = Math.max(0, this.oneShotLockTicks - tickDelta);
                }
                if (this.idleVariantCooldown > 0) {
                    this.idleVariantCooldown = Math.max(0, this.idleVariantCooldown - tickDelta);
                }
                this.lastTickSeen = tickNow;
            }
            if (this.oneShotLockTicks > 0 && this.currentOneShot != null) {
                state.setAndContinue(this.currentOneShot);
                this.dbg("HOLD one-shot -> %s | lock=%d (tickDelta=%d)", this.currentOneShot == PECK ? "PECK" : "SHAKE", this.oneShotLockTicks, tickDelta);
                if (this.oneShotLockTicks <= 0) {
                    this.currentOneShot = null;
                }
                return PlayState.CONTINUE;
            }
            boolean pathing = !this.getNavigation().isDone() && this.getNavigation().getPath() != null;
            double horizVel2 = this.getDeltaMovement().horizontalDistanceSqr();
            boolean bl = fastEnough = horizVel2 > 1.0E-4;
            if ((pathing || fastEnough) && state.isMoving()) {
                state.setAndContinue(WALK);
                return PlayState.CONTINUE;
            }
            if (this.idleVariantCooldown <= 0) {
                if (this.random.nextInt(5) == 0) {
                    state.controller().forceAnimationReset();
                    if (this.random.nextBoolean()) {
                        this.currentOneShot = PECK;
                        this.oneShotLockTicks = 65;
                        state.setAndContinue(PECK);
                        this.dbg("TRIGGER -> PECK (lock=%d)", this.oneShotLockTicks);
                    } else {
                        this.currentOneShot = SHAKE;
                        this.oneShotLockTicks = 55;
                        state.setAndContinue(SHAKE);
                        this.dbg("TRIGGER -> SHAKE (lock=%d)", this.oneShotLockTicks);
                    }
                } else {
                    state.setAndContinue(IDLE);
                }
                this.idleVariantCooldown = 180 + this.random.nextInt(60);
                this.dbg("Ambient window RESET -> %d ticks", this.idleVariantCooldown);
            } else {
                state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }));
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.following != null) {
            this.following.releaseFollower(this);
        }
        if (this.followedBy != null) {
            this.followedBy.setLeader(null);
        }
        this.following = null;
        this.followedBy = null;
        super.remove(reason);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)QuackedSounds.DUCK_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)QuackedSounds.DUCK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)QuackedSounds.DUCK_DEATH.get();
    }

    private void dbg(String fmt, Object ... args) {
    }

    public boolean isLeader() {
        return !this.isBaby() && this.getLeader() == null;
    }

    private void updateOwnerFollowGoal() {
        boolean shouldRemove;
        LivingEntity owner;
        if (this.followOwnerGoal == null) {
            return;
        }
        boolean nearOwner = false;
        if (this.isTame() && (owner = this.getOwner()) != null) {
            nearOwner = this.distanceTo((Entity)owner) < 12.0f;
        }
        boolean head = !this.isBaby() && this.isLeader();
        boolean stableHead = head && this.headStableTicks >= 120;
        boolean shouldAdd = this.isTame() && !this.ownerFollowPaused && stableHead && nearOwner;
        boolean bl = shouldRemove = !this.isTame() || this.ownerFollowPaused || !head || this.isBaby();
        if (shouldAdd && !this.followGoalAdded) {
            this.goalSelector.addGoal(7, (Goal)this.followOwnerGoal);
            this.followGoalAdded = true;
            this.dbg("follow-goal ADDED (prio={}, stableTicks={}, nearOwner={})", 7, this.headStableTicks, nearOwner);
        } else if (this.followGoalAdded && shouldRemove) {
            this.goalSelector.removeGoal((Goal)this.followOwnerGoal);
            this.followGoalAdded = false;
            this.dbg("follow-goal REMOVED (tame={}, paused={}, stableTicks={}, nearOwner={})", this.isTame(), this.ownerFollowPaused, this.headStableTicks, nearOwner);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.idleVariantCooldown > 0) {
                --this.idleVariantCooldown;
            }
            if (this.oneShotLockTicks > 0) {
                --this.oneShotLockTicks;
            }
        }
        if (!this.level().isClientSide) {
            this.headStableTicks = !this.isBaby() && this.isLeader() ? Math.min(this.headStableTicks + 1, 320) : 0;
            if (this.tickCount % 10 == 0) {
                this.updateOwnerFollowGoal();
            }
            if ((this.tickCount & 1) == 0) {
                this.updateDuckState();
            }
        }
    }

    private void updateDuckState() {
        DuckState next = DuckState.IDLE;
        for (WrappedGoal wrapped : this.goalSelector.getAvailableGoals()) {
            if (!wrapped.isRunning()) continue;
            Goal g = wrapped.getGoal();
            DuckState tagged = null;
            if (g instanceof PanicGoal) {
                tagged = DuckState.PANIC;
            } else if (g instanceof AvoidEntityGoal) {
                tagged = DuckState.AVOID;
            } else if (g instanceof LeaderMigrationGoal) {
                tagged = DuckState.MIGRATE;
            } else if (g instanceof FollowOwnerGoal) {
                tagged = DuckState.FOLLOW_OWNER;
            } else if (g instanceof TemptGoal) {
                tagged = DuckState.TEMPT;
            } else if (g instanceof FollowParentGoal) {
                tagged = DuckState.FOLLOW_PARENT;
            } else if (g instanceof FollowLeaderIfFreeGoal) {
                tagged = DuckState.FOLLOW_LEADER;
            } else if (g instanceof RandomStrollGoal) {
                tagged = DuckState.STROLL;
            } else if (g instanceof BreedGoal) {
                tagged = DuckState.BREED;
            }
            if (tagged == null || next.ordinal() <= tagged.ordinal()) continue;
            next = tagged;
        }
        if (next == DuckState.IDLE && this.getDeltaMovement().horizontalDistanceSqr() > 4.0E-4) {
            next = DuckState.STROLL;
        }
        if (next != this.animState) {
            this.animState = next;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean client = this.level().isClientSide;
        if (this.isTame() && this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown() && stack.isEmpty()) {
            if (!client) {
                this.ownerFollowPaused = !this.ownerFollowPaused;
                this.dbg("pause toggled -> {}", this.ownerFollowPaused);
                this.updateOwnerFollowGoal();
            }
            return client ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        if (!this.isTame() && this.isFood(stack)) {
            if (!client) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.tame(player);
                this.setPersistenceRequired();
                this.dbg("tamed by {}", player.getName().getString());
                this.updateOwnerFollowGoal();
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            }
            return client ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(player, hand);
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        out.putBoolean("OwnerFollowPaused", this.ownerFollowPaused);
        this.dbg("save: OwnerFollowPaused={}", this.ownerFollowPaused);
    }

    protected void readAdditionalSaveData(ValueInput in) {
        super.readAdditionalSaveData(in);
        this.ownerFollowPaused = in.getBooleanOr("OwnerFollowPaused", false);
        this.dbg("load: OwnerFollowPaused={}", this.ownerFollowPaused);
        this.updateOwnerFollowGoal();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0).add(Attributes.FLYING_SPEED, 0.9).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 12.0f, 1.0, 1.25));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 12.0f, 1.0, 1.25));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Bee.class, 8.0f, 1.0, 1.25));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.0, 1.25));
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.followOwnerGoal = new FollowOwnerGoal((TamableAnimal)this, 1.05, 8.0f, 44.0f);
        this.goalSelector.addGoal(8, (Goal)new LeaderMigrationGoal(this, 1.12, 3600, 7200));
        this.goalSelector.addGoal(10, (Goal)new LayEggGoal(this, 9000, 100000, QuackyModItems.duckEggSupplier()));
        this.goalSelector.addGoal(11, (Goal)new FollowLeaderIfFreeGoal(this, 1.1, 18.0f, 4.2f, 2.0f));
        this.goalSelector.addGoal(12, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)DUCK_FOOD, false));
        this.goalSelector.addGoal(13, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(14, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.08));
        this.goalSelector.addGoal(15, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(16, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private static enum DuckState {
        PANIC,
        AVOID,
        BREED,
        MIGRATE,
        FOLLOW_OWNER,
        TEMPT,
        FOLLOW_PARENT,
        FOLLOW_LEADER,
        STROLL,
        IDLE;

    }
}

