/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities.ai;

import java.util.EnumSet;
import java.util.List;
import mc.quackedducks.entities.DuckEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;

public class FollowLeaderIfFreeGoal
extends Goal {
    private static final double FAR_MULTIPLIER = 2.25;
    private final DuckEntity duck;
    private DuckEntity leader;
    private final double speed;
    private final float searchRadius;
    private final float startDist;
    private final float stopDist;
    private final double farSpeed;
    private final double nearSpeed;
    private int repathCooldown = 0;

    public FollowLeaderIfFreeGoal(DuckEntity duck, double speed, float searchRadius, float startDist, float stopDist) {
        this.duck = duck;
        this.speed = speed;
        this.searchRadius = searchRadius;
        this.startDist = startDist;
        this.stopDist = stopDist;
        this.farSpeed = speed;
        this.nearSpeed = speed * 0.5;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private static boolean wouldCycle(DuckEntity follower, DuckEntity candidate) {
        int guard = 64;
        for (DuckEntity cur = candidate; cur != null && guard-- > 0; cur = cur.getLeader()) {
            if (cur != follower) continue;
            return true;
        }
        return false;
    }

    public boolean canUse() {
        if (this.duck.getLeader() != null) {
            return false;
        }
        AABB box = this.duck.getBoundingBox().inflate((double)this.searchRadius);
        List candidates = this.duck.level().getEntitiesOfClass(DuckEntity.class, box, c -> c != this.duck && c.isAlive() && !c.isRemoved() && !c.hasFollower() && c.getLeader() != this.duck && !FollowLeaderIfFreeGoal.wouldCycle(this.duck, c));
        if (candidates.isEmpty()) {
            return false;
        }
        DuckEntity nearest = null;
        double bestDistance = Double.MAX_VALUE;
        for (DuckEntity c2 : candidates) {
            double distance2Square = this.duck.distanceToSqr((Entity)c2);
            if (!(distance2Square < bestDistance)) continue;
            bestDistance = distance2Square;
            nearest = c2;
        }
        if (nearest == null || bestDistance <= (double)(this.startDist * this.startDist)) {
            return false;
        }
        this.leader = nearest;
        return true;
    }

    public void start() {
        if (this.leader == null || !this.leader.isAlive() || this.leader.isRemoved()) {
            return;
        }
        if (this.leader == this.duck.getLeader() || FollowLeaderIfFreeGoal.wouldCycle(this.duck, this.leader)) {
            this.leader = null;
            return;
        }
        if (!this.leader.claimFollower(this.duck)) {
            this.leader = null;
            return;
        }
        this.duck.setLeader(this.leader);
        this.duck.getNavigation().moveTo((Entity)this.leader, this.speed);
    }

    public boolean canContinueToUse() {
        double max;
        if (this.leader == null || !this.leader.isAlive() || this.leader.isRemoved()) {
            return false;
        }
        if (this.duck.getLeader() != this.leader) {
            return false;
        }
        double d2 = this.duck.distanceToSqr((Entity)this.leader);
        return d2 < (max = (double)((this.searchRadius + 4.0f) * (this.searchRadius + 4.0f)));
    }

    public void stop() {
        if (this.leader != null) {
            this.leader.releaseFollower(this.duck);
        }
        this.duck.setLeader(null);
        this.leader = null;
        this.duck.getNavigation().stop();
    }

    public void tick() {
        double far2;
        if (this.leader == null) {
            return;
        }
        this.duck.getLookControl().setLookAt((Entity)this.leader, 30.0f, 30.0f);
        double distanceToSquare = this.duck.distanceToSqr((Entity)this.leader);
        double startDistanceSquared = this.startDist * this.startDist;
        double stopDistanceSquared = this.stopDist * this.stopDist;
        if (this.repathCooldown > 0) {
            --this.repathCooldown;
        }
        if (distanceToSquare > (far2 = startDistanceSquared * 5.0625)) {
            if (this.repathCooldown == 0) {
                this.duck.getNavigation().moveTo((Entity)this.leader, this.farSpeed);
                this.repathCooldown = 8;
            }
            return;
        }
        if (distanceToSquare > stopDistanceSquared) {
            if (this.repathCooldown == 0) {
                this.duck.getNavigation().moveTo((Entity)this.leader, this.nearSpeed);
                this.repathCooldown = 10;
            }
            return;
        }
        this.duck.getNavigation().stop();
    }
}

