/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities.ai;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Supplier;
import mc.quackedducks.entities.DuckEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ItemLike;

public class LayEggGoal
extends Goal {
    private final Supplier<? extends ItemLike> eggItemSupplier;
    private final DuckEntity self;
    private final int minIntervalTicks;
    private final int maxIntervalTicks;
    private final Random rng = new Random();
    private int cooldown = 0;

    public LayEggGoal(DuckEntity self, int minIntervalTicks, int maxIntervalTicks, Supplier<? extends ItemLike> eggItemSupplier) {
        this.self = self;
        this.eggItemSupplier = eggItemSupplier;
        this.minIntervalTicks = minIntervalTicks;
        this.maxIntervalTicks = maxIntervalTicks;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean canUse() {
        if (this.self.isBaby() || this.self.level().isClientSide()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return true;
    }

    public void start() {
        this.self.playSound(SoundEvents.CHICKEN_EGG, 1.0f, 1.0f);
        if (!this.self.level().isClientSide()) {
            ServerLevel sl = (ServerLevel)this.self.level();
            this.self.spawnAtLocation(sl, this.eggItemSupplier.get());
        }
        this.cooldown = this.rng.nextInt(this.maxIntervalTicks - this.minIntervalTicks + 1) + this.minIntervalTicks;
    }

    public boolean canContinueToUse() {
        return false;
    }
}

