/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities.ai;

import java.util.EnumSet;
import java.util.Random;
import mc.quackedducks.entities.DuckEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class LeaderMigrationGoal
extends Goal {
    private final Random rng = new Random();
    private final DuckEntity duck;
    private final double speed;
    private final int minDelayTicks;
    private final int maxDelayTicks;
    private int cooldown;
    private Vec3 target;

    public LeaderMigrationGoal(DuckEntity duck, double speed, int minDelayTicks, int maxDelayTicks) {
        this.duck = duck;
        this.speed = speed;
        this.minDelayTicks = minDelayTicks;
        this.maxDelayTicks = maxDelayTicks;
        this.cooldown = 0;
        this.target = null;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.duck.isBaby()) {
            return false;
        }
        if (!this.duck.isLeader()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (this.rng.nextInt(30) != 0) {
            return false;
        }
        double distance = 20.0 + this.rng.nextDouble() * 12.0;
        double angle = this.rng.nextDouble() * Math.PI * 2.0;
        double dx = Math.cos(angle) * distance;
        double dz = Math.sin(angle) * distance;
        double dy = this.rng.nextGaussian() * 1.0;
        Vec3 here = this.duck.position();
        this.target = new Vec3(here.x + dx, here.y + dy, here.z + dz);
        this.cooldown = this.rng.nextInt(this.maxDelayTicks - this.minDelayTicks + 1) + this.minDelayTicks;
        return true;
    }

    public void start() {
        if (this.target != null) {
            this.duck.getNavigation().moveTo(this.target.x, this.target.y, this.target.z, this.speed);
        }
    }

    public boolean canContinueToUse() {
        if (this.duck.isBaby()) {
            return false;
        }
        if (!this.duck.isLeader()) {
            return false;
        }
        return !this.duck.getNavigation().isDone();
    }

    public void stop() {
        this.duck.getNavigation().stop();
        this.target = null;
    }

    public void tick() {
        if (this.target != null) {
            this.duck.getLookControl().setLookAt(this.target.x, this.target.y, this.target.z);
        }
    }
}

