/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities.projectile;

import mc.quackedducks.entities.DuckEntity;
import mc.quackedducks.entities.QuackEntityTypes;
import mc.quackedducks.items.QuackyModItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DuckEggEntity
extends ThrowableItemProjectile {
    public DuckEggEntity(EntityType<? extends DuckEggEntity> type, Level level) {
        super(type, level);
    }

    public DuckEggEntity(Level level, LivingEntity thrower) {
        super((EntityType)QuackEntityTypes.DUCK_EGG_PROJECTILE.get(), thrower, level, new ItemStack(QuackyModItems.duckEggSupplier().get()));
    }

    protected Item getDefaultItem() {
        return QuackyModItems.duckEggSupplier().get().asItem();
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
        }
        if (!this.level().isClientSide) {
            this.hatchBabies();
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity target = hit.getEntity();
        if (!this.level().isClientSide) {
            ServerLevel server = (ServerLevel)this.level();
            DamageSource src = server.damageSources().thrown((Entity)this, this.getOwner());
            target.hurtServer(server, src, 2.0f);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemStack stack = this.getItem();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08);
            }
            return;
        }
        super.handleEntityEvent(id);
    }

    private void hatchBabies() {
        int count = 0;
        if (this.random.nextInt(8) == 0) {
            int n = count = this.random.nextInt(32) == 0 ? 4 : 1;
        }
        if (count <= 0) {
            return;
        }
        ServerLevel server = (ServerLevel)this.level();
        for (int i = 0; i < count; ++i) {
            DuckEntity baby = new DuckEntity((EntityType<? extends DuckEntity>)((EntityType)QuackEntityTypes.DUCK.get()), (Level)server);
            if (baby == null) continue;
            baby.setAge(-24000);
            baby.setPos(this.getX(), this.getY(), this.getZ());
            baby.setYRot(this.getYRot());
            baby.setXRot(0.0f);
            baby.setYHeadRot(baby.getYRot());
            baby.setYBodyRot(baby.getYRot());
            server.addFreshEntity((Entity)baby);
        }
    }
}

