/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.items;

import mc.quackedducks.entities.projectile.DuckEggEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DuckEggItem
extends Item {
    public DuckEggItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            DuckEggEntity proj = new DuckEggEntity(level, (LivingEntity)player);
            proj.setItem(stack.copyWithCount(1));
            proj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)proj);
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return level.isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }
}

