/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.items;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import mc.quackedducks.entities.QuackEntityTypes;
import mc.quackedducks.items.DuckEggItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.ItemLike;

public class QuackyModItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"quack", (ResourceKey)Registries.ITEM);
    private static RegistrySupplier<Item> DUCK_MEAT;
    private static RegistrySupplier<Item> DUCK_FEATHER;
    private static RegistrySupplier<Item> DUCK_FEATHER_ARROW;
    private static RegistrySupplier<Item> COOKED_DUCK;
    private static RegistrySupplier<Item> FOIE_GRAS;
    private static RegistrySupplier<Item> DUCK_SPAWN_EGG;
    private static RegistrySupplier<Item> DUCK_EGG;
    private static RegistrySupplier<Item> EMPTY_FOIE_GRAS_BOWL;

    public static void init() {
        DUCK_EGG = QuackyModItems.registerItem("duck_egg", () -> new DuckEggItem(QuackyModItems.baseProperties("duck_egg").stacksTo(16).arch$tab(CreativeModeTabs.FOOD_AND_DRINKS)));
        DUCK_SPAWN_EGG = QuackyModItems.registerItem("duck_spawn_egg", () -> new SpawnEggItem((EntityType)QuackEntityTypes.DUCK.get(), QuackyModItems.baseProperties("duck_spawn_egg").arch$tab(CreativeModeTabs.SPAWN_EGGS)));
        EMPTY_FOIE_GRAS_BOWL = QuackyModItems.registerItem("empty_foie_gras_bowl", () -> new Item(QuackyModItems.baseProperties("empty_foie_gras_bowl").arch$tab(CreativeModeTabs.FOOD_AND_DRINKS)));
        DUCK_MEAT = QuackyModItems.registerItem("duck_meat", () -> new Item(QuackyModItems.baseProperties("duck_meat").food(new FoodProperties.Builder().nutrition(3).saturationModifier(0.3f).build()).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.HUNGER, 1200, 0), 0.9f)).build()).stacksTo(16).arch$tab(CreativeModeTabs.FOOD_AND_DRINKS)));
        DUCK_FEATHER = QuackyModItems.registerItem("duck_feather", () -> new Item(QuackyModItems.baseProperties("duck_feather").arch$tab(CreativeModeTabs.INGREDIENTS)));
        DUCK_FEATHER_ARROW = QuackyModItems.registerItem("duck_feather_arrow", () -> new ArrowItem(QuackyModItems.baseProperties("duck_feather_arrow").arch$tab(CreativeModeTabs.COMBAT)));
        COOKED_DUCK = QuackyModItems.registerItem("cooked_duck", () -> new Item(QuackyModItems.baseProperties("cooked_duck").food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.8f).build()).stacksTo(16).arch$tab(CreativeModeTabs.FOOD_AND_DRINKS)));
        FOIE_GRAS = QuackyModItems.registerItem("foie_gras", () -> new Item(QuackyModItems.baseProperties("foie_gras").food(new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build()).usingConvertsTo((Item)EMPTY_FOIE_GRAS_BOWL.get()).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 1), 1.0f)).onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.ABSORPTION, 1200, 0), 1.0f)).onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.SATURATION, 20, 0), 1.0f)).build()).stacksTo(1).arch$tab(CreativeModeTabs.FOOD_AND_DRINKS)));
        ITEMS.register();
    }

    private static RegistrySupplier<Item> registerItem(String name, Supplier<Item> item) {
        return ITEMS.register(ResourceLocation.fromNamespaceAndPath((String)"quack", (String)name), item);
    }

    public static Item.Properties baseProperties(String name) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"quack", (String)name)));
    }

    public static Supplier<? extends ItemLike> duckEggSupplier() {
        return DUCK_EGG;
    }
}

