/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities.ai;

import java.util.EnumSet;
import java.util.List;
import mc.quackedducks.entities.DuckEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_238;

public class FollowLeaderIfFreeGoal
extends class_1352 {
    private static final double FAR_MULTIPLIER = 2.25;
    private final DuckEntity duck;
    private DuckEntity leader;
    private final double speed;
    private final float searchRadius;
    private final float startDist;
    private final float stopDist;
    private final double farSpeed;
    private final double nearSpeed;
    private int repathCooldown = 0;

    public FollowLeaderIfFreeGoal(DuckEntity duck, double speed, float searchRadius, float startDist, float stopDist) {
        this.duck = duck;
        this.speed = speed;
        this.searchRadius = searchRadius;
        this.startDist = startDist;
        this.stopDist = stopDist;
        this.farSpeed = speed;
        this.nearSpeed = speed * 0.5;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private static boolean wouldCycle(DuckEntity follower, DuckEntity candidate) {
        int guard = 64;
        for (DuckEntity cur = candidate; cur != null && guard-- > 0; cur = cur.getLeader()) {
            if (cur != follower) continue;
            return true;
        }
        return false;
    }

    public boolean method_6264() {
        if (this.duck.getLeader() != null) {
            return false;
        }
        class_238 box = this.duck.method_5829().method_1014((double)this.searchRadius);
        List candidates = this.duck.method_37908().method_8390(DuckEntity.class, box, c -> c != this.duck && c.method_5805() && !c.method_31481() && !c.hasFollower() && c.getLeader() != this.duck && !FollowLeaderIfFreeGoal.wouldCycle(this.duck, c));
        if (candidates.isEmpty()) {
            return false;
        }
        DuckEntity nearest = null;
        double bestDistance = Double.MAX_VALUE;
        for (DuckEntity c2 : candidates) {
            double distance2Square = this.duck.method_5858((class_1297)c2);
            if (!(distance2Square < bestDistance)) continue;
            bestDistance = distance2Square;
            nearest = c2;
        }
        if (nearest == null || bestDistance <= (double)(this.startDist * this.startDist)) {
            return false;
        }
        this.leader = nearest;
        return true;
    }

    public void method_6269() {
        if (this.leader == null || !this.leader.method_5805() || this.leader.method_31481()) {
            return;
        }
        if (this.leader == this.duck.getLeader() || FollowLeaderIfFreeGoal.wouldCycle(this.duck, this.leader)) {
            this.leader = null;
            return;
        }
        if (!this.leader.claimFollower(this.duck)) {
            this.leader = null;
            return;
        }
        this.duck.setLeader(this.leader);
        this.duck.method_5942().method_6335((class_1297)this.leader, this.speed);
    }

    public boolean method_6266() {
        double max;
        if (this.leader == null || !this.leader.method_5805() || this.leader.method_31481()) {
            return false;
        }
        if (this.duck.getLeader() != this.leader) {
            return false;
        }
        double d2 = this.duck.method_5858((class_1297)this.leader);
        return d2 < (max = (double)((this.searchRadius + 4.0f) * (this.searchRadius + 4.0f)));
    }

    public void method_6270() {
        if (this.leader != null) {
            this.leader.releaseFollower(this.duck);
        }
        this.duck.setLeader(null);
        this.leader = null;
        this.duck.method_5942().method_6340();
    }

    public void method_6268() {
        double far2;
        if (this.leader == null) {
            return;
        }
        this.duck.method_5988().method_6226((class_1297)this.leader, 30.0f, 30.0f);
        double distanceToSquare = this.duck.method_5858((class_1297)this.leader);
        double startDistanceSquared = this.startDist * this.startDist;
        double stopDistanceSquared = this.stopDist * this.stopDist;
        if (this.repathCooldown > 0) {
            --this.repathCooldown;
        }
        if (distanceToSquare > (far2 = startDistanceSquared * 5.0625)) {
            if (this.repathCooldown == 0) {
                this.duck.method_5942().method_6335((class_1297)this.leader, this.farSpeed);
                this.repathCooldown = 8;
            }
            return;
        }
        if (distanceToSquare > stopDistanceSquared) {
            if (this.repathCooldown == 0) {
                this.duck.method_5942().method_6335((class_1297)this.leader, this.nearSpeed);
                this.repathCooldown = 10;
            }
            return;
        }
        this.duck.method_5942().method_6340();
    }
}

