/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;

public final class QuackedConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File("config/quack.json");
    public List<String> biomeAllowlist;
    public List<String> wetBiomeList;
    private static QuackedConfig INSTANCE;

    public static QuackedConfig get() {
        if (INSTANCE == null) {
            INSTANCE = QuackedConfig.load();
        }
        return INSTANCE;
    }

    private static QuackedConfig load() {
        block7: {
            QuackedConfig quackedConfig;
            if (!FILE.exists()) break block7;
            FileReader reader2 = new FileReader(FILE);
            try {
                quackedConfig = (QuackedConfig)GSON.fromJson((Reader)reader2, QuackedConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception reader2) {
                    // empty catch block
                }
            }
            reader2.close();
            return quackedConfig;
        }
        QuackedConfig def = QuackedConfig.defaults();
        QuackedConfig.save(def);
        return def;
    }

    private static void save(QuackedConfig cfg) {
        try {
            FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(FILE);){
                GSON.toJson((Object)cfg, (Appendable)writer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Set<class_2960> getDuckBiomes() {
        HashSet<class_2960> out = new HashSet<class_2960>();
        if (this.biomeAllowlist != null) {
            for (String id : this.biomeAllowlist) {
                try {
                    out.add(class_2960.method_60654((String)id));
                }
                catch (Exception exception) {}
            }
        }
        return out;
    }

    public Set<class_2960> getWetBiomes() {
        HashSet<class_2960> out = new HashSet<class_2960>();
        if (this.wetBiomeList != null) {
            for (String id : this.wetBiomeList) {
                try {
                    out.add(class_2960.method_60654((String)id));
                }
                catch (Exception exception) {}
            }
        }
        return out;
    }

    private static QuackedConfig defaults() {
        QuackedConfig cfg = new QuackedConfig();
        cfg.biomeAllowlist = List.of("minecraft:plains", "minecraft:sunflower_plains", "minecraft:forest", "minecraft:flower_forest", "minecraft:birch_forest", "minecraft:dark_forest", "minecraft:old_growth_birch_forest", "minecraft:meadow", "minecraft:cherry_grove", "minecraft:swamp", "minecraft:mangrove_swamp", "minecraft:river", "minecraft:frozen_river", "minecraft:beach", "minecraft:snowy_beach", "minecraft:stony_shore", "minecraft:taiga", "minecraft:snowy_taiga", "minecraft:old_growth_pine_taiga", "minecraft:old_growth_spruce_taiga", "minecraft:savanna", "minecraft:savanna_plateau", "minecraft:windswept_forest", "minecraft:windswept_hills");
        cfg.wetBiomeList = List.of("minecraft:river", "minecraft:frozen_river", "minecraft:swamp", "minecraft:mangrove_swamp", "minecraft:beach", "minecraft:stony_shore");
        return cfg;
    }
}

