/*
 * Decompiled with CFR 0.152.
 */
package mc.quackedducks.entities;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import mc.quackedducks.entities.QuackEntityTypes;
import mc.quackedducks.entities.ai.FollowLeaderIfFreeGoal;
import mc.quackedducks.entities.ai.LayEggGoal;
import mc.quackedducks.entities.ai.LeaderMigrationGoal;
import mc.quackedducks.items.QuackyModItems;
import mc.quackedducks.sound.QuackedSounds;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1456;
import net.minecraft.class_1493;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4135;
import net.minecraft.class_4466;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DuckEntity
extends class_1321
implements GeoEntity {
    @Nullable
    private DuckEntity following;
    @Nullable
    private DuckEntity followedBy;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.duck.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.duck.walk");
    private static final RawAnimation PECK = RawAnimation.begin().then("animation.duck.peck", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHAKE = RawAnimation.begin().then("animation.duck.shake", Animation.LoopType.PLAY_ONCE);
    private class_1350 followOwnerGoal;
    private static final int OWNER_FOLLOW_PRIORITY = 7;
    private boolean ownerFollowPaused = false;
    private boolean followGoalAdded = false;
    private int headStableTicks = 0;
    private static final int HEAD_STABLE_REQUIRED = 120;
    private static final float OWNER_ENABLE_DIST = 12.0f;
    private static final Logger LOG = LogUtils.getLogger();
    private static final boolean DEBUG_DUCKS = true;
    private DuckState animState = DuckState.IDLE;
    private DuckState lastLoggedState = null;
    private int idleVariantCooldown = 10;
    private int oneShotLockTicks = 0;
    private RawAnimation currentOneShot = null;
    private int lastTickSeen = -1;
    private static final double FOLLOWER_SPEED = 1.1;
    private static final double LEADER_MIGRATE_SPEED = 1.12;
    private static final double AMBIENT_STROLL_SPEED = 1.08;
    private static final class_1856 DUCK_FOOD = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8317, class_1802.field_8309, class_1802.field_46250, class_1802.field_46249, class_1802.field_42711});

    public DuckEntity(class_1299<? extends DuckEntity> type, class_1937 level) {
        super(type, level);
    }

    public boolean method_6481(class_1799 stack) {
        return DUCK_FOOD.method_8093(stack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 partner) {
        return (class_1296)((class_1299)QuackEntityTypes.DUCK.get()).method_5883((class_1937)level, class_3730.field_16466);
    }

    public boolean hasFollower() {
        return this.followedBy != null && this.followedBy.method_5805() && !this.followedBy.method_31481() && this.followedBy.getLeader() == this;
    }

    @Nullable
    public DuckEntity getLeader() {
        return this.following;
    }

    public boolean claimFollower(DuckEntity duck) {
        if (this.method_6109() || duck == null || duck.method_6109()) {
            return false;
        }
        if (this.followedBy == null || !this.followedBy.method_5805()) {
            this.followedBy = duck;
            return true;
        }
        return false;
    }

    public void releaseFollower(DuckEntity duck) {
        if (this.followedBy == duck) {
            this.followedBy = null;
        }
    }

    public void setLeader(@Nullable DuckEntity newLeader) {
        if (this.method_6109()) {
            return;
        }
        if (newLeader != null && newLeader.method_6109()) {
            return;
        }
        DuckEntity prev = this.following;
        this.following = newLeader;
        this.headStableTicks = 0;
        this.dbg("leader set: {} -> {}", prev == null ? "null" : Integer.valueOf(prev.method_5628()), newLeader == null ? "null" : Integer.valueOf(newLeader.method_5628()));
        this.updateOwnerFollowGoal();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("main", 2, state -> {
            boolean fastEnough;
            int tickDelta;
            int tickNow = this.field_6012;
            if (this.lastTickSeen < 0) {
                this.lastTickSeen = tickNow;
            }
            if ((tickDelta = tickNow - this.lastTickSeen) > 0) {
                if (this.oneShotLockTicks > 0) {
                    this.oneShotLockTicks = Math.max(0, this.oneShotLockTicks - tickDelta);
                }
                if (this.idleVariantCooldown > 0) {
                    this.idleVariantCooldown = Math.max(0, this.idleVariantCooldown - tickDelta);
                }
                this.lastTickSeen = tickNow;
            }
            if (this.oneShotLockTicks > 0 && this.currentOneShot != null) {
                state.setAndContinue(this.currentOneShot);
                this.dbg("HOLD one-shot -> %s | lock=%d (tickDelta=%d)", this.currentOneShot == PECK ? "PECK" : "SHAKE", this.oneShotLockTicks, tickDelta);
                if (this.oneShotLockTicks <= 0) {
                    this.currentOneShot = null;
                }
                return PlayState.CONTINUE;
            }
            boolean pathing = !this.method_5942().method_6357() && this.method_5942().method_6345() != null;
            double horizVel2 = this.method_18798().method_37268();
            boolean bl = fastEnough = horizVel2 > 1.0E-4;
            if ((pathing || fastEnough) && state.isMoving()) {
                state.setAndContinue(WALK);
                return PlayState.CONTINUE;
            }
            if (this.idleVariantCooldown <= 0) {
                if (this.field_5974.method_43048(5) == 0) {
                    state.controller().forceAnimationReset();
                    if (this.field_5974.method_43056()) {
                        this.currentOneShot = PECK;
                        this.oneShotLockTicks = 65;
                        state.setAndContinue(PECK);
                        this.dbg("TRIGGER -> PECK (lock=%d)", this.oneShotLockTicks);
                    } else {
                        this.currentOneShot = SHAKE;
                        this.oneShotLockTicks = 55;
                        state.setAndContinue(SHAKE);
                        this.dbg("TRIGGER -> SHAKE (lock=%d)", this.oneShotLockTicks);
                    }
                } else {
                    state.setAndContinue(IDLE);
                }
                this.idleVariantCooldown = 180 + this.field_5974.method_43048(60);
                this.dbg("Ambient window RESET -> %d ticks", this.idleVariantCooldown);
            } else {
                state.setAndContinue(IDLE);
            }
            return PlayState.CONTINUE;
        }));
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (this.following != null) {
            this.following.releaseFollower(this);
        }
        if (this.followedBy != null) {
            this.followedBy.setLeader(null);
        }
        this.following = null;
        this.followedBy = null;
        super.method_5650(reason);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected class_3414 method_5994() {
        return (class_3414)QuackedSounds.DUCK_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)QuackedSounds.DUCK_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)QuackedSounds.DUCK_DEATH.get();
    }

    private void dbg(String fmt, Object ... args) {
        String sfmt = fmt.replace("{}", "%s");
        LOG.info("[duck id={} tame={} leader={} paused={} goalAdded={}] {}", new Object[]{this.method_5628(), this.method_6181(), this.isLeader(), this.ownerFollowPaused, this.followGoalAdded, String.format(sfmt, args)});
    }

    public boolean isLeader() {
        return !this.method_6109() && this.getLeader() == null;
    }

    private void updateOwnerFollowGoal() {
        boolean shouldRemove;
        class_1309 owner;
        if (this.followOwnerGoal == null) {
            return;
        }
        boolean nearOwner = false;
        if (this.method_6181() && (owner = this.method_35057()) != null) {
            nearOwner = this.method_5739((class_1297)owner) < 12.0f;
        }
        boolean head = !this.method_6109() && this.isLeader();
        boolean stableHead = head && this.headStableTicks >= 120;
        boolean shouldAdd = this.method_6181() && !this.ownerFollowPaused && stableHead && nearOwner;
        boolean bl = shouldRemove = !this.method_6181() || this.ownerFollowPaused || !head || this.method_6109();
        if (shouldAdd && !this.followGoalAdded) {
            this.field_6201.method_6277(7, (class_1352)this.followOwnerGoal);
            this.followGoalAdded = true;
            this.dbg("follow-goal ADDED (prio={}, stableTicks={}, nearOwner={})", 7, this.headStableTicks, nearOwner);
        } else if (this.followGoalAdded && shouldRemove) {
            this.field_6201.method_6280((class_1352)this.followOwnerGoal);
            this.followGoalAdded = false;
            this.dbg("follow-goal REMOVED (tame={}, paused={}, stableTicks={}, nearOwner={})", this.method_6181(), this.ownerFollowPaused, this.headStableTicks, nearOwner);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.idleVariantCooldown > 0) {
                --this.idleVariantCooldown;
            }
            if (this.oneShotLockTicks > 0) {
                --this.oneShotLockTicks;
            }
        }
        if (!this.method_37908().field_9236) {
            this.headStableTicks = !this.method_6109() && this.isLeader() ? Math.min(this.headStableTicks + 1, 320) : 0;
            if (this.field_6012 % 10 == 0) {
                this.updateOwnerFollowGoal();
            }
            if ((this.field_6012 & 1) == 0) {
                this.updateDuckState();
            }
        }
    }

    private void updateDuckState() {
        DuckState next = DuckState.IDLE;
        for (class_4135 wrapped : this.field_6201.method_35115()) {
            if (!wrapped.method_19056()) continue;
            class_1352 g = wrapped.method_19058();
            DuckState tagged = null;
            if (g instanceof class_1374) {
                tagged = DuckState.PANIC;
            } else if (g instanceof class_1338) {
                tagged = DuckState.AVOID;
            } else if (g instanceof LeaderMigrationGoal) {
                tagged = DuckState.MIGRATE;
            } else if (g instanceof class_1350) {
                tagged = DuckState.FOLLOW_OWNER;
            } else if (g instanceof class_1391) {
                tagged = DuckState.TEMPT;
            } else if (g instanceof class_1353) {
                tagged = DuckState.FOLLOW_PARENT;
            } else if (g instanceof FollowLeaderIfFreeGoal) {
                tagged = DuckState.FOLLOW_LEADER;
            } else if (g instanceof class_1379) {
                tagged = DuckState.STROLL;
            } else if (g instanceof class_1341) {
                tagged = DuckState.BREED;
            }
            if (tagged == null || next.ordinal() <= tagged.ordinal()) continue;
            next = tagged;
        }
        if (next == DuckState.IDLE && this.method_18798().method_37268() > 4.0E-4) {
            next = DuckState.STROLL;
        }
        if (next != this.animState) {
            this.animState = next;
            if (this.lastLoggedState != this.animState) {
                this.dbg("anim state -> %s", new Object[]{this.animState});
                this.lastLoggedState = this.animState;
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        boolean client = this.method_37908().field_9236;
        if (this.method_6181() && this.method_6171((class_1309)player) && player.method_5715() && stack.method_7960()) {
            if (!client) {
                this.ownerFollowPaused = !this.ownerFollowPaused;
                this.dbg("pause toggled -> {}", this.ownerFollowPaused);
                this.updateOwnerFollowGoal();
            }
            return client ? class_1269.field_5812 : class_1269.field_52422;
        }
        if (!this.method_6181() && this.method_6481(stack)) {
            if (!client) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.method_6170(player);
                this.method_5971();
                this.dbg("tamed by {}", player.method_5477().getString());
                this.updateOwnerFollowGoal();
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            return client ? class_1269.field_5812 : class_1269.field_52422;
        }
        return super.method_5992(player, hand);
    }

    protected void method_5652(class_11372 out) {
        super.method_5652(out);
        out.method_71472("OwnerFollowPaused", this.ownerFollowPaused);
        this.dbg("save: OwnerFollowPaused={}", this.ownerFollowPaused);
    }

    protected void method_5749(class_11368 in) {
        super.method_5749(in);
        this.ownerFollowPaused = in.method_71433("OwnerFollowPaused", false);
        this.dbg("load: OwnerFollowPaused={}", this.ownerFollowPaused);
        this.updateOwnerFollowGoal();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_26827().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_51578, 1.0).method_26868(class_5134.field_23720, 0.9).method_26868(class_5134.field_52450, 16.0).method_26868(class_5134.field_23717, 12.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1588.class, 12.0f, 1.0, 1.25));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1493.class, 12.0f, 1.0, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_4466.class, 8.0f, 1.0, 1.25));
        this.field_6201.method_6277(5, (class_1352)new class_1338((class_1314)this, class_1456.class, 12.0f, 1.0, 1.25));
        this.field_6201.method_6277(6, (class_1352)new class_1341((class_1429)this, 1.0));
        this.followOwnerGoal = new class_1350((class_1321)this, 1.05, 8.0f, 44.0f);
        this.field_6201.method_6277(8, (class_1352)new LeaderMigrationGoal(this, 1.12, 3600, 7200));
        this.field_6201.method_6277(10, (class_1352)new LayEggGoal(this, 9000, 100000, QuackyModItems.duckEggSupplier()));
        this.field_6201.method_6277(11, (class_1352)new FollowLeaderIfFreeGoal(this, 1.1, 18.0f, 4.2f, 2.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1391((class_1314)this, 1.1, (Predicate)DUCK_FOOD, false));
        this.field_6201.method_6277(13, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(14, (class_1352)new class_1379((class_1314)this, 1.08));
        this.field_6201.method_6277(15, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(16, (class_1352)new class_1376((class_1308)this));
    }

    private static enum DuckState {
        PANIC,
        AVOID,
        BREED,
        MIGRATE,
        FOLLOW_OWNER,
        TEMPT,
        FOLLOW_PARENT,
        FOLLOW_LEADER,
        STROLL,
        IDLE;

    }
}

