/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.blocks.entities;

import com.lightending.blocks.BlockStatesDefinition;
import com.lightending.blocks.entities.BlockEntities;
import net.minecraft.advancement.criterion.Criteria;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.damage.DamageSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.particle.ParticleEffect;
import net.minecraft.particle.ParticleTypes;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvents;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.Position;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.World;
import net.minecraft.world.event.BlockPositionSource;
import net.minecraft.world.event.GameEvent;
import net.minecraft.world.event.PositionSource;
import net.minecraft.world.event.listener.GameEventListener;

public class CakeEntity
extends BlockEntity
implements GameEventListener.Holder<Listener> {
    private final Listener eventListener;

    public CakeEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.CAKE_ENTITY, pos, state);
        this.eventListener = new Listener(state, (PositionSource)new BlockPositionSource(pos));
    }

    public static void tick(World world, BlockPos pos, BlockState state, CakeEntity blockEntity) {
    }

    public void readNbt(NbtCompound nbt) {
    }

    protected void writeNbt(NbtCompound nbt) {
        super.writeNbt(nbt);
    }

    public Listener getEventListener() {
        return this.eventListener;
    }

    public class Listener
    implements GameEventListener {
        public static final int RANGE = 8;
        private final BlockState state;
        private final PositionSource positionSource;

        public Listener(BlockState state, PositionSource positionSource) {
            this.state = state;
            this.positionSource = positionSource;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public int getRange() {
            return 8;
        }

        public boolean listen(ServerWorld world, GameEvent event, GameEvent.Emitter emitter, Vec3d emitterPos) {
            Entity entity;
            if (((Boolean)world.getBlockState(CakeEntity.this.pos).get((Property)BlockStatesDefinition.BLOOM)).booleanValue() && event == GameEvent.ENTITY_DIE && (entity = emitter.sourceEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.isExperienceDroppingDisabled()) {
                    int i = livingEntity.getXpToDrop();
                    if (livingEntity.shouldDropXp() && i > 0) {
                        world.setBlockState(BlockPos.ofFloored((Position)emitterPos.offset(Direction.UP, 0.5)), this.state);
                        this.triggerCriteria((World)world, livingEntity);
                    }
                    livingEntity.disableExperienceDropping();
                    this.positionSource.getPos((World)world).ifPresent(pos -> this.bloom(world, BlockPos.ofFloored((Position)pos), this.state, world.getRandom()));
                }
                return true;
            }
            return false;
        }

        public GameEventListener.TriggerOrder getTriggerOrder() {
            return super.getTriggerOrder();
        }

        private void bloom(ServerWorld world, BlockPos pos, BlockState state, Random random) {
            world.scheduleBlockTick(pos, state.getBlock(), 8);
            world.spawnParticles((ParticleEffect)ParticleTypes.HEART, (double)pos.getX() + 0.5, (double)pos.getY() + 1.15, (double)pos.getZ() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            world.playSound(null, pos, SoundEvents.BLOCK_SCULK_CATALYST_BLOOM, SoundCategory.BLOCKS, 2.0f, 0.6f + random.nextFloat() * 0.4f);
        }

        private void triggerCriteria(World world, LivingEntity deadEntity) {
            LivingEntity livingEntity = deadEntity.getAttacker();
            if (livingEntity instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)livingEntity;
                DamageSource damageSource = deadEntity.getRecentDamageSource() == null ? world.getDamageSources().playerAttack((PlayerEntity)serverPlayerEntity) : deadEntity.getRecentDamageSource();
                Criteria.KILL_MOB_NEAR_SCULK_CATALYST.trigger(serverPlayerEntity, (Entity)deadEntity, damageSource);
            }
        }
    }
}

