/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.enchantments;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FrostedIceBlock;
import net.minecraft.block.ShapeContext;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentTarget;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Position;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldView;

public class FrostExplorer
extends Enchantment {
    protected FrostExplorer() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentTarget.ARMOR_HEAD, new EquipmentSlot[]{EquipmentSlot.HEAD});
    }

    public int getMinPower(int level) {
        return level * 10;
    }

    public int getMaxPower(int level) {
        return this.getMinPower(level) + 15;
    }

    public int getMaxLevel() {
        return 2;
    }

    public boolean isTreasure() {
        return true;
    }

    public boolean isCursed() {
        return true;
    }

    public static void freezeWater(LivingEntity entity, World world, BlockPos blockPos, int level) {
        BlockState blockState = Blocks.FROSTED_ICE.getDefaultState();
        int i = Math.min(16, 2 + level);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int j = entity.isSwimming() ? 1 : 2;
        for (BlockPos blockPos2 : BlockPos.iterate((BlockPos)blockPos.add(-i, j, -i), (BlockPos)blockPos.add(i, j, i))) {
            BlockState blockState3;
            if (!blockPos2.isWithinDistance((Position)entity.getPos(), (double)i)) continue;
            mutable.set(blockPos2.getX(), blockPos2.getY() + 1, blockPos2.getZ());
            BlockState blockState2 = world.getBlockState((BlockPos)mutable);
            if (!blockState2.isAir() || (blockState3 = world.getBlockState(blockPos2)) != FrostedIceBlock.getMeltedState() || !blockState.canPlaceAt((WorldView)world, blockPos2) || !world.canPlace(blockState, blockPos2, ShapeContext.absent())) continue;
            world.setBlockState(blockPos2, blockState);
            world.scheduleBlockTick(blockPos2, Blocks.FROSTED_ICE, MathHelper.nextInt((Random)entity.getRandom(), (int)60, (int)120));
        }
    }
}

