/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.enchantments.Enchantments;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PassiveEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimalEntity.class})
public class AnimalEntityMixin
extends PassiveEntity {
    protected AnimalEntityMixin(EntityType<? extends PassiveEntity> entityType, World world) {
        super(entityType, world);
    }

    @Nullable
    public PassiveEntity createChild(ServerWorld world, PassiveEntity entity) {
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"eat"})
    private void injectEat(PlayerEntity player, Hand hand, ItemStack stack, CallbackInfo ci) {
        if (player.getWorld().isClient) {
            return;
        }
        int lvl = EnchantmentHelper.getLevel((Enchantment)Enchantments.OVERDUE, (ItemStack)stack);
        if (lvl >= 0) {
            Random rand = new Random();
            int i = rand.nextInt(100);
            System.out.println(i);
            if (i <= lvl * 10) {
                System.out.println("\u4e2d\u6bd2");
                this.addStatusEffect(new StatusEffectInstance(StatusEffects.POISON, 100, lvl - 1, false, true));
            } else if (i > lvl * 10 & i <= lvl * 20) {
                System.out.println("\u51cb\u96f6");
                this.addStatusEffect(new StatusEffectInstance(StatusEffects.WITHER, 100, lvl - 1, false, true));
            }
        }
    }
}

