/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.blocks.BlockStatesDefinition;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFacingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateManager;
import net.minecraft.state.property.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DyeColor;
import net.minecraft.util.Hand;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.BlockView;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BedBlock.class})
public class BedBlockMixin
extends Block {
    public BedBlockMixin(AbstractBlock.Settings settings) {
        super(settings);
    }

    @Inject(at={@At(value="HEAD")}, method={"appendProperties"})
    private void injectAppend(StateManager.Builder<Block, BlockState> builder, CallbackInfo info) {
        builder.add(new Property[]{BlockStatesDefinition.BINDING});
        builder.add(new Property[]{BlockStatesDefinition.THORNS});
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void injectBed(DyeColor color, AbstractBlock.Settings settings, CallbackInfo ci) {
        this.setDefaultState((BlockState)this.getDefaultState().with((Property)BlockStatesDefinition.BINDING, (Comparable)Boolean.valueOf(false)));
        this.setDefaultState((BlockState)this.getDefaultState().with((Property)BlockStatesDefinition.THORNS, (Comparable)Integer.valueOf(0)));
    }

    @Inject(at={@At(value="RETURN")}, method={"onPlaced"})
    private void injectPlacement(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack, CallbackInfo ci) {
        Direction facing = (Direction)state.get((Property)HorizontalFacingBlock.FACING);
        BlockPos headPos = pos.offset(facing);
        BlockState headState = world.getBlockState(headPos);
        if (headState.getBlock() instanceof BedBlock) {
            world.setBlockState(headPos, (BlockState)((BlockState)headState.with((Property)BlockStatesDefinition.BINDING, (Comparable)((Boolean)world.getBlockState(pos).get((Property)BlockStatesDefinition.BINDING)))).with((Property)BlockStatesDefinition.THORNS, (Comparable)((Integer)world.getBlockState(pos).get((Property)BlockStatesDefinition.THORNS))), 3);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEntityLand"})
    private void injectLand(BlockView world, Entity entity, CallbackInfo ci) {
        World world1 = entity.getWorld();
        BlockPos pos = entity.getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof BedBlock && (Integer)world.getBlockState(pos).get((Property)BlockStatesDefinition.THORNS) > 0) {
            entity.damage(world1.getDamageSources().cactus(), (float)((Integer)world.getBlockState(pos).get((Property)BlockStatesDefinition.THORNS)).intValue());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"onUse"})
    private void injectUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit, CallbackInfoReturnable<ActionResult> cir) {
        if (state.getBlock() instanceof BedBlock && (Integer)world.getBlockState(pos).get((Property)BlockStatesDefinition.THORNS) >= 0) {
            player.damage(world.getDamageSources().cactus(), (float)((Integer)world.getBlockState(pos).get((Property)BlockStatesDefinition.THORNS)).intValue());
        }
    }
}

