/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.mixin.BrushInvoker;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrushableBlock;
import net.minecraft.block.entity.BrushableBlockEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BrushItem;
import net.minecraft.item.ItemStack;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.util.Arm;
import net.minecraft.util.Hand;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.hit.HitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={BrushItem.class})
public class BrushMixin {
    @Overwrite
    public void usageTick(World world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        block12: {
            int sweep;
            BlockHitResult blockHitResult;
            PlayerEntity playerEntity;
            block11: {
                block10: {
                    if (remainingUseTicks < 0 || !(user instanceof PlayerEntity)) {
                        user.stopUsingItem();
                        return;
                    }
                    playerEntity = (PlayerEntity)user;
                    HitResult hitResult = ((BrushInvoker)((Object)this)).invokeGetHitResult(playerEntity);
                    if (!(hitResult instanceof BlockHitResult)) break block10;
                    blockHitResult = (BlockHitResult)hitResult;
                    if (hitResult.getType() == HitResult.Type.BLOCK) break block11;
                }
                user.stopUsingItem();
                return;
            }
            int i = ((BrushInvoker)((Object)this)).invokeGetMaxUseTime(stack) - remainingUseTicks + 1;
            boolean bl = i % 10 == 5;
            boolean bl2 = bl;
            if (!bl) break block12;
            Vec3d lookVec = playerEntity.getRotationVec(1.0f);
            int width = sweep = EnchantmentHelper.getLevel((Enchantment)Enchantments.SWEEPING, (ItemStack)stack);
            int length = sweep;
            BlockPos startPos = blockHitResult.getBlockPos();
            if (Math.abs(lookVec.x) >= Math.abs(lookVec.z)) {
                int x;
                int offsetZ = (int)(Math.signum(lookVec.z) * (double)width);
                int offsetX = (int)(Math.signum(lookVec.x) * (double)length);
                int limX = width;
                int limZ = length;
                startPos = startPos.add(offsetX, 0, offsetZ);
                int n = x = offsetX > 0 ? -offsetX : offsetX;
                while (x <= limX) {
                    int z;
                    int n2 = z = offsetZ > 0 ? -(offsetZ * 2 + 1) : offsetZ * 2 + 1;
                    while (z <= limZ) {
                        BlockPos blockPos = startPos.add(x, 0, z);
                        BlockState blockState = world.getBlockState(blockPos);
                        this.Brush(world, user, stack, playerEntity, blockHitResult, blockState, blockPos);
                        ++z;
                    }
                    ++x;
                }
            } else {
                int x;
                int offsetZ = (int)(Math.signum(lookVec.z) * (double)length);
                int offsetX = (int)(Math.signum(lookVec.x) * (double)width);
                int limX = width;
                int limZ = length;
                startPos = startPos.add(offsetX, 0, offsetZ);
                int n = x = offsetX > 0 ? -(offsetX * 2 + 1) : offsetX * 2 + 1;
                while (x <= limX) {
                    int z;
                    int n3 = z = offsetZ > 0 ? -offsetZ : offsetZ;
                    while (z <= limZ) {
                        BlockPos blockPos = startPos.add(x, 0, z);
                        BlockState blockState = world.getBlockState(blockPos);
                        this.Brush(world, user, stack, playerEntity, blockHitResult, blockState, blockPos);
                        ++z;
                    }
                    ++x;
                }
            }
        }
    }

    private void Brush(World world, LivingEntity user, ItemStack stack, PlayerEntity playerEntity, BlockHitResult blockHitResult, BlockState blockState, BlockPos blockPos) {
        BrushableBlockEntity brushableBlockEntity;
        boolean bl22;
        SoundEvent soundEvent;
        Block object;
        Arm arm = user.getActiveHand() == Hand.MAIN_HAND ? playerEntity.getMainArm() : playerEntity.getMainArm().getOpposite();
        Arm arm2 = arm;
        if (blockState.hasBlockBreakParticles() && blockState.getRenderType() != BlockRenderType.INVISIBLE) {
            ((BrushInvoker)((Object)this)).invokeAddDustParticles(world, blockHitResult, blockState, user.getRotationVec(0.0f), arm);
        }
        if ((object = blockState.getBlock()) instanceof BrushableBlock) {
            BrushableBlock brushableBlock = (BrushableBlock)object;
            soundEvent = brushableBlock.getBrushingSound();
        } else {
            soundEvent = SoundEvents.ITEM_BRUSH_BRUSHING_GENERIC;
        }
        world.playSound(playerEntity, blockPos, soundEvent, SoundCategory.BLOCKS);
        if (!world.isClient() && (object = world.getBlockEntity(blockPos)) instanceof BrushableBlockEntity && (bl22 = (brushableBlockEntity = (BrushableBlockEntity)object).brush(world.getTime(), playerEntity, blockHitResult.getSide()))) {
            EquipmentSlot equipmentSlot = stack.equals(playerEntity.getEquippedStack(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            stack.damage(1, user, userx -> userx.sendEquipmentBreakStatus(equipmentSlot));
        }
    }
}

