/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.blocks.BlockStatesDefinition;
import com.lightending.blocks.entities.CakeEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEntityProvider;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.state.StateManager;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CakeBlock.class})
public class CakeBlockMixin
extends Block
implements BlockEntityProvider {
    public BlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        return new CakeEntity(pos, state);
    }

    public CakeBlockMixin(AbstractBlock.Settings settings) {
        super(settings);
    }

    @Inject(at={@At(value="HEAD")}, method={"appendProperties"})
    private void injectAppend(StateManager.Builder<Block, BlockState> builder, CallbackInfo info) {
        builder.add(new Property[]{BlockStatesDefinition.MENDING});
        builder.add(new Property[]{BlockStatesDefinition.BLOOM});
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void InjectCake(AbstractBlock.Settings settings, CallbackInfo ci) {
        this.setDefaultState((BlockState)this.getDefaultState().with((Property)BlockStatesDefinition.MENDING, (Comparable)Boolean.valueOf(false)));
        this.setDefaultState((BlockState)this.getDefaultState().with((Property)BlockStatesDefinition.BLOOM, (Comparable)Boolean.valueOf(false)));
    }

    public void onEntityCollision(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.isClient) {
            return;
        }
        if (((Boolean)world.getBlockState(pos).get((Property)BlockStatesDefinition.MENDING)).booleanValue() && (Integer)world.getBlockState(pos).get((Property)CakeBlock.BITES) != 0 && entity.getType() == EntityType.EXPERIENCE_ORB) {
            world.setBlockState(pos, (BlockState)state.with((Property)CakeBlock.BITES, (Comparable)Integer.valueOf(0)), 3);
            entity.kill();
        }
    }
}

