/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.projectile.thrown.EggEntity;
import net.minecraft.entity.projectile.thrown.ThrownItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.util.hit.EntityHitResult;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EggEntity.class})
public abstract class EggMixin
extends ThrownItemEntity {
    protected EggMixin(EntityType<? extends EggEntity> entityType, World world) {
        super(entityType, world);
    }

    protected EggMixin(World world, LivingEntity owner) {
        super(EntityType.EGG, owner, world);
    }

    protected EggMixin(World world, double x, double y, double z) {
        super(EntityType.EGG, x, y, z, world);
    }

    @Inject(at={@At(value="RETURN")}, method={"onEntityHit"})
    private void injectHit(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity = entityHitResult.getEntity();
        if (entity.isPlayer()) {
            for (ItemStack item : entity.getArmorItems()) {
                ChickenEntity chickenEntity;
                NbtCompound trimCompound;
                NbtCompound nbt = item.getNbt();
                if (nbt == null || (trimCompound = nbt.getCompound("Trim")).isEmpty()) continue;
                String pattern = trimCompound.getString("pattern");
                System.out.println(pattern);
                if (!Objects.equals(pattern, "randomfun:kun") || (chickenEntity = (ChickenEntity)EntityType.CHICKEN.create(this.getWorld())) == null) continue;
                chickenEntity.setBreedingAge(-24000);
                chickenEntity.refreshPositionAndAngles(this.getX(), this.getY(), this.getZ(), this.getYaw(), 0.0f);
                this.getWorld().spawnEntity((Entity)chickenEntity);
            }
        }
    }
}

