/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.mixin.EntityInvoker;
import com.lightending.mixinHelper.EntityHelper;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPose;
import net.minecraft.entity.ItemEntity;
import net.minecraft.entity.data.TrackedData;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Final
    protected static TrackedData<EntityPose> POSE;
    @Shadow
    private World world;

    @Shadow
    public abstract Iterable<ItemStack> getArmorItems();

    @Shadow
    public abstract boolean isPlayer();

    @Shadow
    public abstract World getWorld();

    @Shadow
    public abstract boolean isSneaking();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Inject(at={@At(value="HEAD")}, method={"setPose"}, cancellable=true)
    private void injectSetPose(EntityPose pose, CallbackInfo ci) {
        if (EntityHelper.globalIsBinded) {
            ((EntityInvoker)((Object)this)).getDataTracker().set(POSE, (Object)EntityPose.SLEEPING);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setSneaking"})
    private void injectSetSneaking(boolean sneaking, CallbackInfo ci) {
        if (this.isPlayer() && this.isSneaking()) {
            for (ItemStack item : this.getArmorItems()) {
                NbtCompound trimCompound;
                NbtCompound nbt = item.getNbt();
                if (nbt == null || (trimCompound = nbt.getCompound("Trim")).isEmpty()) continue;
                String pattern = trimCompound.getString("pattern");
                System.out.println(pattern);
                if (!Objects.equals(pattern, "randomfun:kun")) continue;
                World world1 = this.getWorld();
                ItemStack egg = new ItemStack((ItemConvertible)Items.EGG, 1);
                ItemEntity eggEntity = new ItemEntity(world1, this.getX(), this.getY(), this.getZ(), egg);
                world1.spawnEntity((Entity)eggEntity);
            }
        }
    }
}

