/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.blocks.BlockStatesDefinition;
import com.lightending.enchantments.Enchantments;
import com.lightending.enchantments.FrostExplorer;
import com.lightending.mixin.LivingEntityInvoker;
import java.util.Random;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Attackable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPose;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements Attackable {
    private BlockPos pos;

    @Shadow
    protected abstract boolean wouldNotSuffocateInPose(EntityPose var1);

    public LivingEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"applyFoodEffects"})
    private void injectApplyFoodEffects(ItemStack stack, World world, LivingEntity targetEntity, CallbackInfo ci) {
        if (world.isClient()) {
            return;
        }
        int lvl = EnchantmentHelper.getLevel((Enchantment)Enchantments.OVERDUE, (ItemStack)stack);
        if (lvl >= 0) {
            Random rand = new Random();
            int i = rand.nextInt(100);
            System.out.println(i);
            if (i <= lvl * 10) {
                System.out.println("\u4e2d\u6bd2");
                targetEntity.addStatusEffect(new StatusEffectInstance(StatusEffects.POISON, 100, lvl - 1, false, true));
            } else if (i > lvl * 10 & i <= lvl * 20) {
                System.out.println("\u51cb\u96f6");
                targetEntity.addStatusEffect(new StatusEffectInstance(StatusEffects.WITHER, 100, lvl - 1, false, true));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"wakeUp()V"})
    private void injectWakeUp(CallbackInfo ci) {
        this.pos = this.getBlockPos();
    }

    @Inject(at={@At(value="RETURN")}, method={"wakeUp()V"})
    private void injectWakeUpRet(CallbackInfo ci) {
        World world = this.getWorld();
        BlockState blockState = world.getBlockState(this.pos);
        if (this.getType() == EntityType.VILLAGER && blockState.getBlock() instanceof BedBlock && ((Boolean)world.getBlockState(this.pos).get((Property)BlockStatesDefinition.BINDING)).booleanValue()) {
            this.setPose(EntityPose.SLEEPING);
            this.setPosition((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6875, (double)this.pos.getZ() + 0.5);
            ((LivingEntityInvoker)((Object)this)).invokeAddStatusEffect(new StatusEffectInstance(StatusEffects.SLOWNESS, Integer.MAX_VALUE, 99, false, false));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"applyMovementEffects"})
    private void injectMovement(BlockPos pos, CallbackInfo ci) {
        int i = EnchantmentHelper.getEquipmentLevel((Enchantment)Enchantments.FROST_EXPLORER, (LivingEntity)((LivingEntity)this));
        if (i > 0) {
            FrostExplorer.freezeWater((LivingEntity)this, this.getWorld(), pos, i);
        }
    }
}

