/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.blocks.BlockStatesDefinition;
import com.lightending.mixin.PlayerEntityAccessor;
import com.lightending.mixinHelper.EntityHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerMixin
extends LivingEntity {
    public Boolean isBinded = false;
    private BlockPos pos;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Shadow
    public abstract void readCustomDataFromNbt(NbtCompound var1);

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void injectTickRet(CallbackInfo ci) {
        World world = this.getWorld();
        BlockPos pos1 = this.getBlockPos();
        if (this.isSleeping() && ((Boolean)world.getBlockState(pos1).get((Property)BlockStatesDefinition.BINDING)).booleanValue()) {
            int a = ((PlayerEntityAccessor)((Object)this)).getSleepTimer();
            ((PlayerEntityAccessor)((Object)this)).setSleepTimer(--a);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"wakeUp(ZZ)V"})
    private void injectWakeUp(CallbackInfo ci) {
        this.pos = this.getBlockPos();
    }

    @Inject(at={@At(value="RETURN")}, method={"wakeUp(ZZ)V"})
    private void injectWakeUpRet(CallbackInfo ci) {
        World world = this.getWorld();
        if (!world.isClient && ((Boolean)world.getBlockState(this.pos).get((Property)BlockStatesDefinition.BINDING)).booleanValue()) {
            this.setPosition((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6875, (double)this.pos.getZ() + 0.5);
            EntityHelper.transIsBinded(true);
            this.addStatusEffect(new StatusEffectInstance(StatusEffects.SLOWNESS, Integer.MAX_VALUE, 99, false, false));
        }
    }
}

