/*
 * Decompiled with CFR 0.152.
 */
package com.lightending.mixin;

import com.lightending.mixin.ThrownItemEntityInvoker;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.thrown.ThrownEntity;
import net.minecraft.entity.projectile.thrown.ThrownItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownEntity.class})
public abstract class ThrownEntityMixin
extends ProjectileEntity {
    @Unique
    int loyaltyTimer;

    public ThrownEntityMixin(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void injectTick(CallbackInfo ci) {
        ThrownEntityMixin thrownEntityMixin = this;
        if (thrownEntityMixin instanceof ThrownItemEntity) {
            ThrownItemEntity thrownItemEntity = (ThrownItemEntity)thrownEntityMixin;
            ++this.loyaltyTimer;
            if (this.loyaltyTimer >= 0) {
                Entity entity = this.getOwner();
                ItemStack itemStack = ((ThrownItemEntityInvoker)thrownItemEntity).invokeGetItem();
                int lvl = EnchantmentHelper.getLevel((Enchantment)Enchantments.LOYALTY, (ItemStack)itemStack);
                if (lvl != 0 && entity != null) {
                    if (!this.isOwnerAlive()) {
                        if (!this.getWorld().isClient) {
                            this.dropStack(itemStack, 0.1f);
                        }
                        this.discard();
                    } else {
                        Vec3d vec3d = entity.getEyePos().subtract(this.getPos());
                        this.setPos(this.getX(), this.getY() + vec3d.y * 0.015 * (double)lvl, this.getZ());
                        if (this.getWorld().isClient) {
                            this.lastRenderY = this.getY();
                        }
                        double d = 0.05 * (double)lvl;
                        this.setVelocity(this.getVelocity().multiply(0.95).add(vec3d.normalize().multiply(d)));
                    }
                }
            }
        }
    }

    @Unique
    private boolean isOwnerAlive() {
        Entity entity = this.getOwner();
        if (entity == null || !entity.isAlive()) {
            return false;
        }
        return !(entity instanceof ServerPlayerEntity) || !entity.isSpectator();
    }
}

