/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.builderstrowels;

import com.samxel.builderstrowels.registry.ModDataComponents;
import com.samxel.builderstrowels.tooltip.TrowelBlacklistTooltip;
import com.samxel.builderstrowels.util.BlacklistContents;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;

public class TrowelItem
extends Item {
    private final float cooldownSeconds;
    private final int blacklistCapacity;

    public TrowelItem(Item.Properties props, float cooldownSeconds, int blacklistCapacity) {
        super(props);
        this.cooldownSeconds = cooldownSeconds;
        this.blacklistCapacity = blacklistCapacity;
    }

    private static void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private BlacklistContents getBlacklist(ItemStack stack) {
        BlacklistContents contents = (BlacklistContents)stack.get((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value());
        if (contents == null) {
            contents = BlacklistContents.EMPTY;
            stack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)contents);
        }
        return contents;
    }

    private void setBlacklist(ItemStack stack, BlacklistContents contents) {
        stack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)contents);
    }

    private boolean isBlacklisted(ItemStack stack, Item item) {
        ItemStack test = new ItemStack((ItemLike)item);
        return this.getBlacklist(stack).contains(test);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null || level.isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack trowel = context.getItemInHand();
        if (player.getCooldowns().isOnCooldown(trowel)) {
            return InteractionResult.FAIL;
        }
        ArrayList<ItemStack> hotbarBlocks = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack s = player.getInventory().getItem(i);
            if (s.isEmpty() || !((item = s.getItem()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (this.isBlacklisted(trowel, s.getItem())) continue;
            hotbarBlocks.add(s);
        }
        if (hotbarBlocks.isEmpty()) {
            return InteractionResult.FAIL;
        }
        ItemStack picked = (ItemStack)hotbarBlocks.get(player.getRandom().nextInt(hotbarBlocks.size()));
        BlockItem blockItem = (BlockItem)picked.getItem();
        BlockPos placePos = context.getClickedPos().relative(context.getClickedFace());
        if (!level.getBlockState(placePos).canBeReplaced()) {
            return InteractionResult.FAIL;
        }
        BlockHitResult hit = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
        UseOnContext placeCtx = new UseOnContext(level, player, context.getHand(), picked, hit);
        InteractionResult result = picked.useOn(placeCtx);
        if (result.consumesAction()) {
            player.swing(context.getHand(), true);
            SoundType st = blockItem.getBlock().defaultBlockState().getSoundType();
            level.playSound(null, context.getClickedPos(), st.getPlaceSound(), SoundSource.BLOCKS, (st.getVolume() + 1.0f) / 2.0f, st.getPitch() * 0.8f);
            if (!player.isCreative()) {
                trowel.hurtAndBreak(1, (LivingEntity)player, context.getHand());
            }
            player.getCooldowns().addCooldown(trowel, (int)(this.cooldownSeconds * 20.0f));
        }
        return result;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        BlacklistContents bl = this.getBlacklist(stack);
        if (this.blacklistCapacity == 0) {
            return Optional.empty();
        }
        return Optional.of(new TrowelBlacklistTooltip(bl, this.blacklistCapacity));
    }

    public boolean overrideStackedOnOther(ItemStack trowelStack, Slot slot, ClickAction action, Player player) {
        BlacklistContents contents = this.getBlacklist(trowelStack);
        if (trowelStack.getCount() != 1) {
            return false;
        }
        ItemStack targetItem = slot.getItem();
        if (action == ClickAction.PRIMARY && !targetItem.isEmpty()) {
            if (!contents.contains(targetItem)) {
                BlacklistContents updated = contents.add(targetItem, this.blacklistCapacity);
                trowelStack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)updated);
                TrowelItem.playInsertSound((Entity)player);
            } else {
                TrowelItem.playInsertFailSound((Entity)player);
            }
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        if (action == ClickAction.SECONDARY && targetItem.isEmpty() && !contents.isEmpty()) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(contents.items());
            list.remove(list.size() - 1);
            trowelStack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)new BlacklistContents(list));
            TrowelItem.playRemoveOneSound((Entity)player);
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack trowelStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (trowelStack.getCount() != 1) {
            return false;
        }
        BlacklistContents contents = this.getBlacklist(trowelStack);
        if (action == ClickAction.PRIMARY && !otherStack.isEmpty()) {
            if (slot.allowModification(player) && !contents.contains(otherStack)) {
                BlacklistContents updated = contents.add(otherStack, this.blacklistCapacity);
                trowelStack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)updated);
                TrowelItem.playInsertSound((Entity)player);
                this.broadcastChangesOnContainerMenu(player);
                return true;
            }
            TrowelItem.playInsertFailSound((Entity)player);
        } else if (action == ClickAction.SECONDARY && otherStack.isEmpty() && slot.allowModification(player) && !contents.isEmpty()) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(contents.items());
            list.remove(list.size() - 1);
            trowelStack.set((DataComponentType)ModDataComponents.BLACKLIST_CONTENTS.value(), (Object)new BlacklistContents(list));
            TrowelItem.playRemoveOneSound((Entity)player);
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        return false;
    }

    private void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu container = player.containerMenu;
        if (container != null) {
            container.slotsChanged((Container)player.getInventory());
        }
    }
}

