/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.builderstrowels.tooltip;

import com.samxel.builderstrowels.tooltip.FakeBundleContents;
import com.samxel.builderstrowels.tooltip.TrowelBlacklistTooltip;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class ClientTrowelBlacklistTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BAR_BORDER = ResourceLocation.withDefaultNamespace((String)"container/bundle/bundle_progressbar_border");
    private static final ResourceLocation BAR_FILL = ResourceLocation.withDefaultNamespace((String)"container/bundle/bundle_progressbar_fill");
    private static final ResourceLocation BAR_FULL = ResourceLocation.withDefaultNamespace((String)"container/bundle/bundle_progressbar_full");
    private static final ResourceLocation SLOT_BG = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot_background");
    private static final Component DESC = Component.translatable((String)"tooltip.builderstrowels.blacklist.empty.description");
    private final FakeBundleContents contents;
    private final int currentCount;
    private final int maxCount;

    public ClientTrowelBlacklistTooltip(TrowelBlacklistTooltip tooltip) {
        List<ItemStack> items = tooltip.contents().itemsCopy();
        this.currentCount = items.size();
        this.maxCount = Math.max(1, tooltip.maxCapacity());
        Fraction weight = Fraction.getFraction((int)Math.min(this.currentCount, this.maxCount), (int)this.maxCount);
        this.contents = new FakeBundleContents(items, weight, -1);
    }

    private static int getEmptyHeight(Font f) {
        return f.split((FormattedText)DESC, 96).size() * 9 + 13 + 8;
    }

    public int getHeight(Font f) {
        int n;
        if (this.contents.isEmpty()) {
            n = ClientTrowelBlacklistTooltip.getEmptyHeight(f);
        } else {
            int n2 = this.gridHeight() + 13 + 8;
            Objects.requireNonNull(f);
            n = n2 + 9 + 2;
        }
        return n;
    }

    public int getWidth(Font f) {
        return 96;
    }

    public boolean showTooltipWithItemInHand() {
        return true;
    }

    private int gridHeight() {
        return Mth.positiveCeilDiv((int)Math.min(12, this.contents.size()), (int)4) * 24;
    }

    private int offset(int width) {
        return (width - 96) / 2;
    }

    public void renderImage(Font f, int x, int y, int w, int h, GuiGraphics gfx) {
        int ox = x + this.offset(w);
        if (this.contents.isEmpty()) {
            int textHeight = f.split((FormattedText)DESC, 96).size() * 9;
            gfx.drawWordWrap(f, (FormattedText)DESC, ox, y, 96, -5592406);
            this.drawBar(f, ox, y + textHeight + 4, gfx);
        } else {
            MutableComponent title = Component.literal((String)"Blacklist:");
            gfx.drawString(f, (Component)title, ox, y, -5592406, false);
            Objects.requireNonNull(f);
            int titleHeight = 9 + 2;
            this.drawItems(f, x, y + titleHeight, w, gfx);
            this.drawBar(f, ox, y + titleHeight + this.gridHeight() + 4, gfx);
        }
    }

    private void drawItems(Font f, int x, int y, int w, GuiGraphics gfx) {
        List<ItemStack> items = this.contents.items();
        int xStart = x + this.offset(w);
        int yStart = y;
        int index = 0;
        for (int row = 0; row < Mth.positiveCeilDiv((int)items.size(), (int)4); ++row) {
            for (int col = 0; col < 4; ++col) {
                if (index >= items.size()) {
                    return;
                }
                int sx = xStart + col * 24;
                int sy = yStart + row * 24;
                gfx.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_BG, sx, sy, 24, 24);
                ItemStack stack = items.get(index);
                gfx.renderItem(stack, sx + 4, sy + 4, index);
                gfx.renderItemDecorations(f, stack, sx + 4, sy + 4);
                ++index;
            }
        }
    }

    private void drawBar(Font f, int x, int y, GuiGraphics gfx) {
        int fill = Mth.clamp((int)Mth.mulAndTruncate((Fraction)this.contents.weight(), (int)94), (int)0, (int)94);
        gfx.blitSprite(RenderPipelines.GUI_TEXTURED, this.getBarTex(), x + 1, y, fill, 13);
        gfx.blitSprite(RenderPipelines.GUI_TEXTURED, BAR_BORDER, x, y, 96, 13);
        MutableComponent txt = Component.literal((String)(this.currentCount + "/" + this.maxCount));
        gfx.drawCenteredString(f, (Component)txt, x + 48, y + 3, -1);
    }

    private ResourceLocation getBarTex() {
        return this.contents.weight().compareTo(Fraction.ONE) >= 0 ? BAR_FULL : BAR_FILL;
    }
}

