/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.builderstrowels.util;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record BlacklistContents(List<ItemStack> items) {
    public static final BlacklistContents EMPTY = new BlacklistContents(List.of());
    public static final Codec<BlacklistContents> CODEC = ItemStack.CODEC.listOf().xmap(BlacklistContents::new, BlacklistContents::items);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlacklistContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BlacklistContents::new, BlacklistContents::items);

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    public List<ItemStack> itemsCopy() {
        return this.items.stream().map(ItemStack::copy).toList();
    }

    public BlacklistContents add(ItemStack stack, int capacity) {
        if (this.items.size() >= capacity) {
            return this;
        }
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(this.items);
        newList.add(stack.copyWithCount(1));
        return new BlacklistContents(newList);
    }

    public boolean contains(ItemStack stack) {
        for (ItemStack i : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)i, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public BlacklistContents remove(ItemStack stack) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(this.items);
        newList.removeIf(e -> ItemStack.isSameItemSameComponents((ItemStack)e, (ItemStack)stack));
        return new BlacklistContents(newList);
    }
}

