/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.Messenger;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.brigadier.CommandDispatcher;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import io.github.optijava.opt_carpet_addition.commands.CommandLoggerCommand;
import io.github.optijava.opt_carpet_addition.commands.CrashCommand;
import io.github.optijava.opt_carpet_addition.commands.ListAdvanceCommand;
import io.github.optijava.opt_carpet_addition.commands.PlayerTpCommand;
import io.github.optijava.opt_carpet_addition.commands.TpLimitCommand;
import io.github.optijava.opt_carpet_addition.events.fixExperienceBug.FixExperienceBug;
import io.github.optijava.opt_carpet_addition.logger.LoggerRegister;
import io.github.optijava.opt_carpet_addition.utils.CommandLogger;
import io.github.optijava.opt_carpet_addition.utils.ConfigUtil;
import io.github.optijava.opt_carpet_addition.utils.TpLimit;
import java.io.File;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptCarpetAddition
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"OptCarpetAddition");

    public void onInitialize() {
        LOGGER.info("OptCarpetAddition is loading...");
        CarpetServer.manageExtension((CarpetExtension)new OptCarpetAddition());
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((Object)new FixExperienceBug());
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(OptCarpetSettings.class);
        CarpetServer.settingsManager.registerRuleObserver((serverCommandSource, rule, s) -> {
            if (Objects.equals(rule.name(), "forceFakePlayerGameMode") && !Objects.equals(OptCarpetSettings.forceFakePlayerGameMode, "false")) {
                class_1934 gameMode = class_1934.field_9215;
                if (OptCarpetSettings.forceFakePlayerGameMode.equals("creative")) {
                    gameMode = class_1934.field_9220;
                } else if (OptCarpetSettings.forceFakePlayerGameMode.equals("adventure")) {
                    gameMode = class_1934.field_9216;
                }
                for (class_3222 player : serverCommandSource.method_9211().method_3760().method_14571()) {
                    if (!(player instanceof EntityPlayerMPFake)) continue;
                    player.method_7336(gameMode);
                }
            }
            if (rule.name().equals("enableTpPrefixBlacklist") && OptCarpetSettings.enableTpPrefixBlacklist && OptCarpetSettings.enableTpPrefixWhitelist) {
                OptCarpetSettings.enableTpPrefixBlacklist = false;
                Messenger.m((class_2168)serverCommandSource, (Object[])new Object[]{"r You can't enable TpPrefixBlacklist because you have enabled TpPrefixWhitelist"});
            }
            if (rule.name().equals("enableTpPrefixWhitelist") && OptCarpetSettings.enableTpPrefixWhitelist && OptCarpetSettings.enableTpPrefixBlacklist) {
                OptCarpetSettings.enableTpPrefixWhitelist = false;
                Messenger.m((class_2168)serverCommandSource, (Object[])new Object[]{"r You can't enable TpPrefixWhitelist because you have enabled TpPrefixBlacklist"});
            }
            if (rule.name().equals("enableTpherePrefixWhitelist") && OptCarpetSettings.enableTpHerePrefixWhitelist && OptCarpetSettings.enableTpHerePrefixBlacklist) {
                OptCarpetSettings.enableTpHerePrefixWhitelist = false;
                Messenger.m((class_2168)serverCommandSource, (Object[])new Object[]{"r You can't enable TpherePrefixWhitelist because you have enabled TpherePrefixBlacklist"});
            }
            if (rule.name().equals("enableTpherePrefixBlacklist") && OptCarpetSettings.enableTpHerePrefixBlacklist && OptCarpetSettings.enableTpHerePrefixWhitelist) {
                OptCarpetSettings.enableTpHerePrefixBlacklist = false;
                Messenger.m((class_2168)serverCommandSource, (Object[])new Object[]{"r You can't enable TpherePrefixBlacklist because you have enabled TpherePrefixWhitelist"});
            }
            if (rule.name().equals("playerTpRateLimitTime")) {
                double time = OptCarpetSettings.playerTpRateLimitTime == 0 ? 0.0 : 1.0 / (double)OptCarpetSettings.playerTpRateLimitTime;
                for (RateLimiter rateLimiter : PlayerTpCommand.rateLimiterMap.values()) {
                    rateLimiter.setRate(time);
                }
            }
        });
        if (!ConfigUtil.init()) {
            LOGGER.error("Failed to create config folder: {}{}opt-carpet-addition", (Object)OptCarpetSettings.configDirectory.toString(), (Object)File.separator);
            return;
        }
        TpLimit.loadConfigFile();
        CommandLogger.loadConfigFile();
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        PlayerTpCommand.registerCommands(dispatcher);
        ListAdvanceCommand.registerCommand(dispatcher);
        TpLimitCommand.registerCommand(dispatcher);
        CommandLoggerCommand.registerCommand(dispatcher);
        CrashCommand.registerCommand(dispatcher);
    }

    public void onPlayerLoggedIn(class_3222 player) {
        if (player instanceof EntityPlayerMPFake && !Objects.equals(OptCarpetSettings.forceFakePlayerGameMode, "false")) {
            class_1934 gameMode = class_1934.field_9215;
            if (OptCarpetSettings.forceFakePlayerGameMode.equals("creative")) {
                gameMode = class_1934.field_9220;
            } else if (OptCarpetSettings.forceFakePlayerGameMode.equals("adventure")) {
                gameMode = class_1934.field_9216;
            }
            player.method_7336(gameMode);
        }
        double time = OptCarpetSettings.playerTpRateLimitTime == 0 ? 0.0 : 1.0 / (double)OptCarpetSettings.playerTpRateLimitTime;
        PlayerTpCommand.rateLimiterMap.put(player, RateLimiter.create((double)time));
    }

    public void onPlayerLoggedOut(class_3222 player) {
        PlayerTpCommand.rateLimiterMap.remove(player);
    }

    public void registerLoggers() {
        LoggerRegister.registry();
    }
}

