/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.github.optijava.opt_carpet_addition.OptCarpetAddition;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import io.github.optijava.opt_carpet_addition.utils.ConfigUtil;
import io.github.optijava.opt_carpet_addition.utils.config_bean.CommandLoggerConfigBean;
import java.util.Objects;

public class CommandLogger {
    private static final Gson gson = new Gson();

    public static void loadConfigFile() {
        String FILE_NAME = "CommandLogger.json";
        if (!ConfigUtil.exists("CommandLogger.json")) {
            if (!ConfigUtil.create("CommandLogger.json")) {
                OptCarpetAddition.LOGGER.error("Failed to create config file: CommandLogger.json");
                return;
            }
            if (!ConfigUtil.write("CommandLogger.json", "{\n  \"logAllCommand\": false,\n  \"LogCommandWhitelist\": [],\n  \"LogCommandBlacklist\": [],\n  \"LogCommandPrefixWhitelist\": [],\n  \"LogCommandPrefixBlacklist\": []\n}")) {
                OptCarpetAddition.LOGGER.error("Failed to init config file: CommandLogger.json");
                return;
            }
        }
        try {
            String content = ConfigUtil.load("CommandLogger.json");
            Objects.requireNonNull(content);
            if (content.equals("Failed")) {
                OptCarpetAddition.LOGGER.error("Failed to read config file CommandLogger.json");
                return;
            }
            OptCarpetSettings.commandLoggerConfigBean = (CommandLoggerConfigBean)gson.fromJson(content, CommandLoggerConfigBean.class);
        }
        catch (JsonSyntaxException e) {
            OptCarpetAddition.LOGGER.error((Object)new RuntimeException("Exception when parsed json config file.", e));
        }
        finally {
            if (OptCarpetSettings.commandLoggerConfigBean == null) {
                OptCarpetSettings.commandLoggerConfigBean = new CommandLoggerConfigBean();
            }
        }
    }

    public static int reload() {
        CommandLogger.loadConfigFile();
        return 1;
    }
}

