/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition.commands;

import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.Messenger;
import com.google.common.util.concurrent.RateLimiter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.optijava.opt_carpet_addition.OptCarpetAddition;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PlayerTpCommand {
    public static Map<class_3222, RateLimiter> rateLimiterMap = new HashMap<class_3222, RateLimiter>();
    private static final String COMMAND_PREFIX = "player";

    private PlayerTpCommand() {
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_PREFIX).then(((RequiredArgumentBuilder)class_2170.method_9244((String)COMMAND_PREFIX, (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)"tp").executes(PlayerTpCommand::teleport))).then(class_2170.method_9247((String)"tphere").executes(PlayerTpCommand::teleportHere)));
        dispatcher.register(argumentBuilder);
    }

    private static boolean ratelimit(CommandContext<class_2168> context) {
        if (OptCarpetSettings.playerTpRateLimitTime == 0) {
            return true;
        }
        boolean canTeleport = true;
        try {
            RateLimiter r = rateLimiterMap.get(((class_2168)context.getSource()).method_9207());
            canTeleport = r.tryAcquire();
        }
        catch (Exception ex) {
            OptCarpetAddition.LOGGER.error((Object)ex);
        }
        return canTeleport;
    }

    private static int teleport(CommandContext<class_2168> context) {
        if (!PlayerTpCommand.ratelimit(context)) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Too fast!"});
            return 0;
        }
        String target = StringArgumentType.getString(context, (String)COMMAND_PREFIX);
        if (CarpetServer.minecraft_server.method_3760().method_14566(target) == null) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r No such player"});
            return 0;
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        if (((class_2168)context.getSource()).equals(server.method_3739())) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Console can't tp to player."});
            OptCarpetAddition.LOGGER.warn("Console can't tp to player");
            return 0;
        }
        if (StringArgumentType.getString(context, (String)COMMAND_PREFIX).isEmpty() || target == null) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Invalid player name."});
            return 0;
        }
        try {
            String commandSourcePlayerName = Objects.requireNonNull(((class_2168)context.getSource()).method_9207()).method_7334().getName();
            if (server.method_3760().method_14566(target) instanceof EntityPlayerMPFake) {
                switch (OptCarpetSettings.commandTpToFakePlayer) {
                    case "true": {
                        PlayerTpCommand.executeTp(commandSourcePlayerName, context, server);
                        break;
                    }
                    case "ops": {
                        if (server.method_3760().method_14569(((class_2168)context.getSource()).method_9207().method_7334())) {
                            PlayerTpCommand.executeTp(commandSourcePlayerName, context, server);
                            break;
                        }
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You have no permission to teleport to fake player.You aren't op."});
                        break;
                    }
                    case "false": {
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Anybody can't teleport to fake player."});
                    }
                }
            } else {
                switch (OptCarpetSettings.allowTpToRealPlayer) {
                    case "true": {
                        server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + commandSourcePlayerName + " " + target, (Object)server.method_3739()));
                        break;
                    }
                    case "ops": {
                        if (server.method_3760().method_14569(((class_2168)context.getSource()).method_9207().method_7334())) {
                            server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + commandSourcePlayerName + " " + target, (Object)server.method_3739()));
                            break;
                        }
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You have no permission to teleport to real player.You aren't op."});
                        break;
                    }
                    case "false": {
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Anybody can't teleport to real player."});
                    }
                }
            }
        }
        catch (CommandSyntaxException e) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Maybe player name is not correct."});
            OptCarpetAddition.LOGGER.error("Unknown error occurred when execute command.", (Throwable)e);
            return 0;
        }
        return 1;
    }

    private static int teleportHere(CommandContext<class_2168> context) {
        if (!PlayerTpCommand.ratelimit(context)) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Too fast!"});
            return 0;
        }
        String target = StringArgumentType.getString(context, (String)COMMAND_PREFIX);
        if (CarpetServer.minecraft_server.method_3760().method_14566(target) == null) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r No such player"});
            return 0;
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        if (((class_2168)context.getSource()).equals(server.method_3739())) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Console can't tp here player."});
            OptCarpetAddition.LOGGER.warn("Console can't tp here player");
            return 0;
        }
        if (StringArgumentType.getString(context, (String)COMMAND_PREFIX).isEmpty() || target == null) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Invalid player name."});
            return 0;
        }
        try {
            String commandSourcePlayerName = Objects.requireNonNull(((class_2168)context.getSource()).method_9207()).method_7334().getName();
            if (server.method_3760().method_14566(target) instanceof EntityPlayerMPFake) {
                switch (OptCarpetSettings.commandTpHereFakePlayer) {
                    case "true": {
                        PlayerTpCommand.executeTpHere(commandSourcePlayerName, context, server);
                        break;
                    }
                    case "ops": {
                        if (server.method_3760().method_14569(((class_2168)context.getSource()).method_9207().method_7334())) {
                            PlayerTpCommand.executeTpHere(commandSourcePlayerName, context, server);
                            break;
                        }
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You have no permission to teleport here fake player.You aren't op."});
                        break;
                    }
                    case "false": {
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Anybody can't teleport here fake player."});
                    }
                }
            } else {
                switch (OptCarpetSettings.allowTpHereRealPlayer) {
                    case "true": {
                        server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + target + " " + commandSourcePlayerName, (Object)server.method_3739()));
                        break;
                    }
                    case "ops": {
                        if (server.method_3760().method_14569(((class_2168)context.getSource()).method_9207().method_7334())) {
                            server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + target + " " + commandSourcePlayerName, (Object)server.method_3739()));
                            break;
                        }
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You have no permission to teleport here real player.You aren't op."});
                        break;
                    }
                    case "false": {
                        Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Anybody can't teleport here real player."});
                    }
                }
            }
        }
        catch (CommandSyntaxException e) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Unknown error occurred when execute command : com.mojang.brigadier.exceptions.CommandSyntaxException"});
            OptCarpetAddition.LOGGER.error("Unknown error occurred when execute command.", (Throwable)e);
            return 0;
        }
        return 1;
    }

    private static void executeTp(String commandSourcePlayerName, CommandContext<class_2168> context, MinecraftServer server) {
        String target = StringArgumentType.getString(context, (String)COMMAND_PREFIX);
        try {
            if (OptCarpetSettings.enableTpPrefixWhitelist && PlayerTpCommand.checkTpWhitelist(StringArgumentType.getString(context, (String)COMMAND_PREFIX))) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + commandSourcePlayerName + " " + target, (Object)server.method_3739()));
            } else if (OptCarpetSettings.enableTpPrefixBlacklist && PlayerTpCommand.checkTpBlacklist(StringArgumentType.getString(context, (String)COMMAND_PREFIX))) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + commandSourcePlayerName + " " + target, (Object)server.method_3739()));
            } else if (!OptCarpetSettings.enableTpPrefixBlacklist && !OptCarpetSettings.enableTpPrefixWhitelist) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + commandSourcePlayerName + " " + target, (Object)server.method_3739()));
            } else {
                Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You can't tp to this player because of tp limit."});
            }
        }
        catch (CommandSyntaxException e) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Unknown error occurred when execute command : com.mojang.brigadier.exceptions.CommandSyntaxException"});
            OptCarpetAddition.LOGGER.error("Unknown error occurred when execute command.", (Throwable)e);
        }
    }

    private static void executeTpHere(String commandSourcePlayerName, CommandContext<class_2168> context, MinecraftServer server) {
        String target = StringArgumentType.getString(context, (String)COMMAND_PREFIX);
        try {
            if (OptCarpetSettings.enableTpHerePrefixWhitelist && PlayerTpCommand.checkTpHereWhitelist(StringArgumentType.getString(context, (String)COMMAND_PREFIX))) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + target + " " + commandSourcePlayerName, (Object)server.method_3739()));
            } else if (OptCarpetSettings.enableTpHerePrefixBlacklist && PlayerTpCommand.checkTpHereBlacklist(StringArgumentType.getString(context, (String)COMMAND_PREFIX))) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + target + " " + commandSourcePlayerName, (Object)server.method_3739()));
            } else if (!OptCarpetSettings.enableTpHerePrefixBlacklist && !OptCarpetSettings.enableTpHerePrefixWhitelist) {
                server.method_3734().method_9235().execute(server.method_3734().method_9235().parse("tp " + target + " " + commandSourcePlayerName, (Object)server.method_3739()));
            } else {
                Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r You can't tp here this player because of tp limit."});
            }
        }
        catch (CommandSyntaxException e) {
            Messenger.m((class_2168)((class_2168)context.getSource()), (Object[])new Object[]{"r Unknown error occurred when execute command : com.mojang.brigadier.exceptions.CommandSyntaxException"});
            OptCarpetAddition.LOGGER.error("Unknown error occurred when execute command.", (Throwable)e);
        }
    }

    private static boolean checkTpBlacklist(String name) {
        for (String s : OptCarpetSettings.tpLimitConfigBean.TpBlacklist) {
            if (!name.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkTpWhitelist(String name) {
        for (String s : OptCarpetSettings.tpLimitConfigBean.TpWhitelist) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkTpHereBlacklist(String name) {
        for (String s : OptCarpetSettings.tpLimitConfigBean.TphereBlacklist) {
            if (!name.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkTpHereWhitelist(String name) {
        for (String s : OptCarpetSettings.tpLimitConfigBean.TphereWhitelist) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

