/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition.mixins.rule.async;

import io.github.optijava.opt_carpet_addition.OptCarpetAddition;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import io.github.optijava.opt_carpet_addition.utils.threading.Threading;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MinecraftServer.class})
public class MinecraftServer_Mixin {
    @Inject(method={"shutdown()V"}, at={@At(value="HEAD")})
    public void injectShutdown(CallbackInfo ci) {
        OptCarpetAddition.LOGGER.info("[OptCarpetAddition] Closing thread pool...");
        Threading.THREAD_POOL.shutdown();
        OptCarpetAddition.LOGGER.info("[OptCarpetAddition] Thread pool closed successfully!");
    }

    @Inject(method={"tickWorlds"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/crash/CrashReport;create(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/util/crash/CrashReport;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    public void injectTickWorlds(BooleanSupplier shouldKeepTicking, CallbackInfo ci, Iterator var2, class_3218 serverWorld, Throwable throwable) {
        if (OptCarpetSettings.optimizePlayerConnect && throwable instanceof ConcurrentModificationException) {
            OptCarpetAddition.LOGGER.fatal("[OptCarpetAddition] Unexpected exception when ticking world: {}", (Object)serverWorld.toString(), (Object)throwable);
            OptCarpetAddition.LOGGER.fatal("[OptCarpetAddition] If you see this message, you may need to restart the server. This exception may cause by OptCarpetAddition, if you think so, please send the reports to GitHub Issues.");
            OptCarpetAddition.LOGGER.fatal("[OptCarpetAddition] I'm sorry to hear that.");
            ci.cancel();
        }
    }
}

