/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.context.CommandContext;
import io.github.optijava.opt_carpet_addition.OptCarpetAddition;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import io.github.optijava.opt_carpet_addition.utils.ConfigUtil;
import io.github.optijava.opt_carpet_addition.utils.config_bean.TpLimitConfigBean;
import java.util.Objects;
import net.minecraft.class_2168;

public class TpLimit {
    private static final Gson gson = new Gson();

    public static void loadConfigFile() {
        String FILE_NAME = "TpLimit.json";
        if (!ConfigUtil.exists("TpLimit.json")) {
            if (!ConfigUtil.create("TpLimit.json")) {
                OptCarpetAddition.LOGGER.error("Failed to create config file: TpLimit.json");
                return;
            }
            if (!ConfigUtil.write("TpLimit.json", "{\n  \"TpWhitelist\": [],\n  \"TpBlacklist\": [],\n  \"TphereWhitelist\": [],\n  \"TphereBlacklist\": []\n}")) {
                OptCarpetAddition.LOGGER.error("Failed to init config file: TpLimit.json");
                return;
            }
        }
        try {
            String content = ConfigUtil.load("TpLimit.json");
            Objects.requireNonNull(content);
            if (content.equals("Failed")) {
                OptCarpetAddition.LOGGER.error("Failed to read config file TpLimit.json");
                return;
            }
            OptCarpetSettings.tpLimitConfigBean = (TpLimitConfigBean)gson.fromJson(content, TpLimitConfigBean.class);
        }
        catch (JsonSyntaxException e) {
            OptCarpetAddition.LOGGER.error((Object)new RuntimeException("Exception when parsed json config file.", e));
        }
        finally {
            if (OptCarpetSettings.tpLimitConfigBean == null) {
                OptCarpetSettings.tpLimitConfigBean = new TpLimitConfigBean();
            }
        }
    }

    public static void add(String prefix, String whichList) {
        switch (whichList) {
            case "TpBlacklist": {
                OptCarpetSettings.tpLimitConfigBean.TpBlacklist.add(prefix);
                break;
            }
            case "TpWhitelist": {
                OptCarpetSettings.tpLimitConfigBean.TpWhitelist.add(prefix);
                break;
            }
            case "TphereWhitelist": {
                OptCarpetSettings.tpLimitConfigBean.TphereWhitelist.add(prefix);
                break;
            }
            case "TphereBlacklist": {
                OptCarpetSettings.tpLimitConfigBean.TphereBlacklist.add(prefix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid list name.");
            }
        }
    }

    public static void remove(String prefix, String whichList) {
        switch (whichList) {
            case "TpBlacklist": {
                OptCarpetSettings.tpLimitConfigBean.TpBlacklist.remove(prefix);
                break;
            }
            case "TpWhitelist": {
                OptCarpetSettings.tpLimitConfigBean.TpWhitelist.remove(prefix);
                break;
            }
            case "TphereWhitelist": {
                OptCarpetSettings.tpLimitConfigBean.TphereWhitelist.remove(prefix);
                break;
            }
            case "TphereBlacklist": {
                OptCarpetSettings.tpLimitConfigBean.TphereBlacklist.remove(prefix);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid list name.");
            }
        }
    }

    public static void flush() {
        ConfigUtil.write("TpLimit.json", gson.toJson((Object)OptCarpetSettings.tpLimitConfigBean));
    }

    public static int reload(CommandContext<class_2168> context) {
        TpLimit.loadConfigFile();
        return 1;
    }
}

