/*
 * Decompiled with CFR 0.152.
 */
package io.github.optijava.opt_carpet_addition.utils;

import io.github.optijava.opt_carpet_addition.OptCarpetAddition;
import io.github.optijava.opt_carpet_addition.OptCarpetSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;

public class ConfigUtil {
    public static String load(String fileName) {
        try {
            return Files.readString(OptCarpetSettings.configDirectory.resolve(fileName), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            OptCarpetAddition.LOGGER.error((Object)e);
            return "Failed";
        }
    }

    public static boolean create(String fileName) {
        try {
            Files.createFile(OptCarpetSettings.configDirectory.resolve(fileName), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            OptCarpetAddition.LOGGER.error((Object)e);
            return false;
        }
    }

    public static boolean init() {
        File file = OptCarpetSettings.configDirectory.toFile();
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean exists(String fileName) {
        return Files.exists(OptCarpetSettings.configDirectory.resolve(fileName), new LinkOption[0]);
    }

    public static boolean write(String fileName, String content) {
        try {
            Files.write(OptCarpetSettings.configDirectory.resolve(fileName), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            OptCarpetAddition.LOGGER.error((Object)e);
            return false;
        }
        return true;
    }
}

