/*
 * Decompiled with CFR 0.152.
 */
package libs.felnull.fnnbs;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import libs.felnull.fnnbs.Layer;
import libs.felnull.fnnbs.impl.NBSImpl;
import libs.felnull.fnnbs.instrument.CustomInstrument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface NBS {
    @NotNull
    public static NBS load(InputStream stream) throws IOException {
        return new NBSImpl(stream);
    }

    public boolean isOld();

    public int getVersion();

    public int getVanillaInstrumentCount();

    public int getSongLength();

    public int getLayerCount();

    public int getActualLayerCount();

    public Layer getLayer(int var1);

    @NotNull
    public String getName();

    @NotNull
    public String getAuthor();

    @NotNull
    public String getOriginalAuthor();

    @NotNull
    public String getDescription();

    public int getTempo();

    public boolean isAutoSaving();

    public int getAutoSavingDuration();

    public int getTimeSignature();

    public int getMinutesSpent();

    public int getLeftClicks();

    public int getRightClicks();

    public int getNoteBlocksAdded();

    public int getNoteBlocksRemoved();

    @NotNull
    public String getImportFileName();

    public boolean isLoop();

    public int getLoopCount();

    public int getLoopStart();

    @NotNull
    public @Unmodifiable List<Layer> getLayers();

    @NotNull
    public @Unmodifiable List<CustomInstrument> getCustomInstruments();
}

