/*
 * Decompiled with CFR 0.152.
 */
package libs.felnull.fnnbs;

import libs.felnull.fnnbs.NBS;
import libs.felnull.fnnbs.instrument.Instrument;
import libs.felnull.fnnbs.instrument.VanillaInstrument;
import org.jetbrains.annotations.NotNull;

public interface Note {
    public int getInstrument();

    public int getKey();

    public int getPanning();

    public int getPitch();

    public int getVelocity();

    default public float getRawVelocity() {
        return (float)this.getVelocity() / 100.0f;
    }

    @NotNull
    default public Instrument getInstrument(NBS nbs) {
        if (nbs.getVanillaInstrumentCount() > this.getInstrument() && VanillaInstrument.values().length > this.getInstrument()) {
            return VanillaInstrument.values()[this.getInstrument()];
        }
        int cc = this.getInstrument() - nbs.getVanillaInstrumentCount();
        return nbs.getCustomInstruments().get(cc);
    }
}

