/*
 * Decompiled with CFR 0.152.
 */
package libs.felnull.fnnbs.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import libs.felnull.fnnbs.Layer;
import libs.felnull.fnnbs.Note;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayerImpl
implements Layer {
    private final Map<Integer, Note> notes = new TreeMap<Integer, Note>();
    private String name;
    private boolean lock;
    private int volume = 100;
    private int stereo;

    protected void addNote(int tick, Note note) {
        this.notes.put(tick, note);
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLock(boolean lock) {
        this.lock = lock;
    }

    protected void setStereo(int stereo) {
        this.stereo = stereo;
    }

    protected void setVolume(int volume) {
        this.volume = volume;
    }

    @Override
    public int getStereo() {
        return this.stereo;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public boolean isLock() {
        return this.lock;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Note getNote(int tick) {
        return this.notes.get(tick);
    }

    @Override
    @NotNull
    public Map<Integer, Note> getNotes() {
        return Collections.unmodifiableMap(this.notes);
    }

    public String toString() {
        return "LayerImpl{notes=" + String.valueOf(this.notes) + ", name='" + this.name + "', lock=" + this.lock + ", volume=" + this.volume + ", stereo=" + this.stereo + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerImpl layer = (LayerImpl)o;
        return this.lock == layer.lock && this.volume == layer.volume && this.stereo == layer.stereo && Objects.equals(this.notes, layer.notes) && Objects.equals(this.name, layer.name);
    }

    public int hashCode() {
        return Objects.hash(this.notes, this.name, this.lock, this.volume, this.stereo);
    }
}

