/*
 * Decompiled with CFR 0.152.
 */
package libs.felnull.fnnbs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import libs.felnull.fnnbs.Layer;
import libs.felnull.fnnbs.NBS;
import libs.felnull.fnnbs.impl.LayerImpl;
import libs.felnull.fnnbs.impl.NoteImpl;
import libs.felnull.fnnbs.impl.instrument.CustomInstrumentImpl;
import libs.felnull.fnnbs.instrument.CustomInstrument;
import org.jetbrains.annotations.NotNull;

public class NBSImpl
implements NBS {
    private final boolean old;
    private final int version;
    private final int vanillaInstrumentCount;
    private final int songLength;
    private final int layerCount;
    private final String name;
    private final String author;
    private final String originalAuthor;
    private final String description;
    private final int tempo;
    private final boolean autoSaving;
    private final int autoSavingDuration;
    private final int timeSignature;
    private final int minutesSpent;
    private final int leftClicks;
    private final int rightClicks;
    private final int noteBlocksAdded;
    private final int noteBlocksRemoved;
    private final String importFileName;
    private final boolean loop;
    private final int loopCount;
    private final int loopStart;
    private final List<LayerImpl> layers = new ArrayList<LayerImpl>();
    private final List<CustomInstrumentImpl> customInstruments = new ArrayList<CustomInstrumentImpl>();

    public NBSImpl(InputStream stream) throws IOException {
        int fl = NBSImpl.readShort(stream);
        boolean bl = this.old = fl != 0;
        if (this.old) {
            this.version = 0;
            this.vanillaInstrumentCount = 10;
            this.songLength = fl;
        } else {
            this.version = stream.read();
            this.vanillaInstrumentCount = stream.read();
            this.songLength = NBSImpl.readShort(stream);
        }
        if (this.version > 5) {
            throw new RuntimeException("Unsupported nbs version");
        }
        this.layerCount = NBSImpl.readShort(stream);
        for (int i = 0; i < this.layerCount; ++i) {
            this.layers.add(new LayerImpl());
        }
        this.name = NBSImpl.readString(stream);
        this.author = NBSImpl.readString(stream);
        this.originalAuthor = NBSImpl.readString(stream);
        this.description = NBSImpl.readString(stream);
        this.tempo = NBSImpl.readShort(stream);
        this.autoSaving = NBSImpl.readBoolean(stream);
        this.autoSavingDuration = stream.read();
        this.timeSignature = stream.read();
        this.minutesSpent = NBSImpl.readInt(stream);
        this.leftClicks = NBSImpl.readInt(stream);
        this.rightClicks = NBSImpl.readInt(stream);
        this.noteBlocksAdded = NBSImpl.readInt(stream);
        this.noteBlocksRemoved = NBSImpl.readInt(stream);
        this.importFileName = NBSImpl.readString(stream);
        if (this.old) {
            this.loop = false;
            this.loopCount = -1;
            this.loopStart = -1;
        } else {
            this.loop = NBSImpl.readBoolean(stream);
            this.loopCount = stream.read();
            this.loopStart = NBSImpl.readShort(stream);
        }
        int tick = -1;
        int nextJT = NBSImpl.readShort(stream);
        while (nextJT != 0) {
            tick += nextJT;
            int layer = -1;
            int nextJL = NBSImpl.readShort(stream);
            while (nextJL != 0) {
                layer += nextJL;
                int instrument = stream.read();
                int key = stream.read();
                int velocity = this.old ? 100 : stream.read();
                int panning = this.old ? 100 : stream.read();
                int pitch = this.old ? 0 : NBSImpl.readSignedShort(stream);
                NoteImpl note = new NoteImpl(instrument, key, velocity, panning, pitch);
                int ls = this.layers.size();
                if (ls <= layer) {
                    for (int i = 0; i <= ls - layer; ++i) {
                        this.layers.add(new LayerImpl());
                    }
                }
                this.layers.get(layer).addNote(tick, note);
                nextJL = NBSImpl.readShort(stream);
            }
            nextJT = NBSImpl.readShort(stream);
        }
        for (int i = 0; i < this.layerCount; ++i) {
            LayerImpl layer = this.layers.get(i);
            layer.setName(NBSImpl.readString(stream));
            if (!this.old) {
                layer.setLock(NBSImpl.readBoolean(stream));
            }
            layer.setVolume(stream.read());
            if (this.old) continue;
            layer.setStereo(stream.read());
        }
        int cic = stream.read();
        if (cic != -1) {
            for (int i = 0; i < cic; ++i) {
                this.customInstruments.add(new CustomInstrumentImpl(NBSImpl.readString(stream), NBSImpl.readString(stream), stream.read(), NBSImpl.readBoolean(stream)));
            }
        }
    }

    private static int readSignedShort(InputStream stream) throws IOException {
        return (short)(stream.read() | stream.read() << 8);
    }

    private static boolean readBoolean(InputStream stream) throws IOException {
        return stream.read() >= 1;
    }

    private static String readString(InputStream stream) throws IOException {
        int len = NBSImpl.readInt(stream);
        if (len < 0) {
            throw new IOException("Invalid string length");
        }
        byte[] dat = new byte[len];
        int ren = stream.read(dat);
        if (ren < 0) {
            throw new IOException("String length mismatch");
        }
        return new String(dat, StandardCharsets.UTF_8);
    }

    private static int readInt(InputStream stream) throws IOException {
        return stream.read() + (stream.read() << 8) + (stream.read() << 16) + (stream.read() << 24);
    }

    private static int readShort(InputStream stream) throws IOException {
        return stream.read() + (stream.read() << 8);
    }

    @Override
    @NotNull
    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    @Override
    @NotNull
    public List<CustomInstrument> getCustomInstruments() {
        return Collections.unmodifiableList(this.customInstruments);
    }

    @Override
    public boolean isOld() {
        return this.old;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getVanillaInstrumentCount() {
        return this.vanillaInstrumentCount;
    }

    @Override
    public int getSongLength() {
        return this.songLength;
    }

    @Override
    public int getLayerCount() {
        return this.layerCount;
    }

    @Override
    public int getActualLayerCount() {
        return this.layers.size();
    }

    @Override
    public Layer getLayer(int num) {
        return this.layers.get(num);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getAuthor() {
        return this.author;
    }

    @Override
    @NotNull
    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getTempo() {
        return this.tempo;
    }

    @Override
    public boolean isAutoSaving() {
        return this.autoSaving;
    }

    @Override
    public int getAutoSavingDuration() {
        return this.autoSavingDuration;
    }

    @Override
    public int getTimeSignature() {
        return this.timeSignature;
    }

    @Override
    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    @Override
    public int getLeftClicks() {
        return this.leftClicks;
    }

    @Override
    public int getRightClicks() {
        return this.rightClicks;
    }

    @Override
    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    @Override
    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    @Override
    @NotNull
    public String getImportFileName() {
        return this.importFileName;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    @Override
    public int getLoopStart() {
        return this.loopStart;
    }

    public String toString() {
        return "NBSImpl{old=" + this.old + ", version=" + this.version + ", vanillaInstrumentCount=" + this.vanillaInstrumentCount + ", songLength=" + this.songLength + ", layerCount=" + this.layerCount + ", name='" + this.name + "', author='" + this.author + "', originalAuthor='" + this.originalAuthor + "', description='" + this.description + "', tempo=" + this.tempo + ", autoSaving=" + this.autoSaving + ", autoSavingDuration=" + this.autoSavingDuration + ", timeSignature=" + this.timeSignature + ", minutesSpent=" + this.minutesSpent + ", leftClicks=" + this.leftClicks + ", rightClicks=" + this.rightClicks + ", noteBlocksAdded=" + this.noteBlocksAdded + ", noteBlocksRemoved=" + this.noteBlocksRemoved + ", importFileName='" + this.importFileName + "', loop=" + this.loop + ", loopCount=" + this.loopCount + ", loopStart=" + this.loopStart + ", layers=" + this.layers.size() + ", customInstruments=" + this.customInstruments.size() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBSImpl nbs = (NBSImpl)o;
        return this.old == nbs.old && this.version == nbs.version && this.vanillaInstrumentCount == nbs.vanillaInstrumentCount && this.songLength == nbs.songLength && this.layerCount == nbs.layerCount && this.tempo == nbs.tempo && this.autoSaving == nbs.autoSaving && this.autoSavingDuration == nbs.autoSavingDuration && this.timeSignature == nbs.timeSignature && this.minutesSpent == nbs.minutesSpent && this.leftClicks == nbs.leftClicks && this.rightClicks == nbs.rightClicks && this.noteBlocksAdded == nbs.noteBlocksAdded && this.noteBlocksRemoved == nbs.noteBlocksRemoved && this.loop == nbs.loop && this.loopCount == nbs.loopCount && this.loopStart == nbs.loopStart && Objects.equals(this.name, nbs.name) && Objects.equals(this.author, nbs.author) && Objects.equals(this.originalAuthor, nbs.originalAuthor) && Objects.equals(this.description, nbs.description) && Objects.equals(this.importFileName, nbs.importFileName) && Objects.equals(this.layers, nbs.layers) && Objects.equals(this.customInstruments, nbs.customInstruments);
    }

    public int hashCode() {
        return Objects.hash(this.old, this.version, this.vanillaInstrumentCount, this.songLength, this.layerCount, this.name, this.author, this.originalAuthor, this.description, this.tempo, this.autoSaving, this.autoSavingDuration, this.timeSignature, this.minutesSpent, this.leftClicks, this.rightClicks, this.noteBlocksAdded, this.noteBlocksRemoved, this.importFileName, this.loop, this.loopCount, this.loopStart, this.layers, this.customInstruments);
    }
}

