/*
 * Decompiled with CFR 0.152.
 */
package libs.felnull.fnnbs.impl.instrument;

import java.util.Objects;
import libs.felnull.fnnbs.instrument.CustomInstrument;
import org.jetbrains.annotations.NotNull;

public class CustomInstrumentImpl
implements CustomInstrument {
    private final String name;
    private final String fileName;
    private final int pitch;
    private final boolean pressKeys;

    public CustomInstrumentImpl(String name, String fileName, int pitch, boolean autoPressKeys) {
        this.name = name;
        this.fileName = fileName;
        this.pitch = pitch;
        this.pressKeys = autoPressKeys;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isPressKeys() {
        return this.pressKeys;
    }

    @Override
    @NotNull
    public String getSoundName() {
        return this.name;
    }

    @Override
    public boolean isVanillaNote() {
        return false;
    }

    @Override
    public float getDefaultPitch() {
        return this.pitch;
    }

    public String toString() {
        return "CustomInstrumentImpl{name='" + this.name + "', fileName='" + this.fileName + "', pitch=" + this.pitch + ", pressKeys=" + this.pressKeys + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomInstrumentImpl that = (CustomInstrumentImpl)o;
        return this.pitch == that.pitch && this.pressKeys == that.pressKeys && Objects.equals(this.name, that.name) && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fileName, this.pitch, this.pressKeys);
    }
}

