/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nayrus.noteblockmaster.block.AdvancedNoteBlock;
import net.nayrus.noteblockmaster.item.TunerItem;
import net.nayrus.noteblockmaster.screen.CoreScreen;
import net.nayrus.noteblockmaster.setup.NBMTags;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.sound.AdvancedInstrument;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class TuningCore
extends TransparentBlock {
    public static int SUSTAIN_MAXVAL = 1;
    public static final IntegerProperty VOLUME = IntegerProperty.create((String)"volume", (int)0, (int)20);
    public static IntegerProperty SUSTAIN;
    public static final BooleanProperty POWERED;
    public static final DeferredSoundType CORE_SOUNDS;
    public static final VoxelShape COLLISION;
    public static final List<BlockPos> BREAK_DELAY;

    public TuningCore(ResourceLocation key) {
        super(BlockBehaviour.Properties.of().instabreak().noCollission().noOcclusion().sound((SoundType)CORE_SOUNDS).isValidSpawn(Blocks::never).isSuffocating((a, b, c) -> false).isViewBlocking((a, b, c) -> false).dynamicShape().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)VOLUME, (Comparable)Integer.valueOf(0))).setValue((Property)SUSTAIN, (Comparable)Integer.valueOf(0))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static void loadSustainProperty() {
        SUSTAIN = IntegerProperty.create((String)"sustain", (int)0, (int)SUSTAIN_MAXVAL);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VOLUME, SUSTAIN, POWERED});
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack weapon = player.getWeaponItem();
        if (!weapon.is(NBMTags.Items.CORE_DESTROY) || BREAK_DELAY.contains(pos.immutable())) {
            return state;
        }
        if (this.hasStackEnoughIronToDestroy(weapon, state) || player.isCreative()) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        if (weapon.is(NBMTags.Items.TUNERS) && this.hasPlayerEnoughIronToDestroy(player, state)) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        return state;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ItemStack weapon = player.getWeaponItem();
        if (!weapon.is(NBMTags.Items.CORE_DESTROY) || BREAK_DELAY.contains(pos.immutable())) {
            return false;
        }
        if (weapon.is(Items.IRON_NUGGET)) {
            if (this.hasStackEnoughIronToDestroy(weapon, state)) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            if (player.getInventory().countItem(Items.IRON_NUGGET) > 0) {
                if (!level.isClientSide()) {
                    this.removeOneCore(state, level, pos, player, player.isShiftKeyDown());
                }
                return false;
            }
            return false;
        }
        if (weapon.is(NBMTags.Items.TUNERS)) {
            if (this.hasPlayerEnoughIronToDestroy(player, state) || player.isCreative()) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            if (player.getInventory().countItem(Items.IRON_NUGGET) > 0) {
                if (!level.isClientSide()) {
                    this.removeOneCore(state, level, pos, player, player.isShiftKeyDown());
                }
                return false;
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected boolean hasPlayerEnoughIronToDestroy(Player player, BlockState state) {
        return player.getInventory().contains(item -> {
            if (!item.is(Items.IRON_NUGGET)) {
                return false;
            }
            if (TuningCore.isMixing(state) && TuningCore.isSustaining(state)) {
                return item.getCount() >= 2;
            }
            return item.getCount() >= 1;
        });
    }

    protected boolean hasStackEnoughIronToDestroy(ItemStack item, BlockState state) {
        if (!item.is(Items.IRON_NUGGET)) {
            return false;
        }
        if (item.getCount() >= 2) {
            return true;
        }
        return (!TuningCore.isMixing(state) || !TuningCore.isSustaining(state)) && item.getCount() == 1;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Player player;
        FinalTuple.ItemStackTuple items;
        EntityCollisionContext eCon;
        if (!(context instanceof EntityCollisionContext) || (eCon = (EntityCollisionContext)context).equals(CollisionContext.empty())) {
            return COLLISION;
        }
        Entity entity = eCon.getEntity();
        if (entity instanceof Player && ((items = FinalTuple.getHeldItems(player = (Player)entity)).contains(TunerItem.class) || items.contains(Items.IRON_NUGGET))) {
            return COLLISION;
        }
        return Shapes.empty();
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        Level level2 = level.getChunk(pos).getLevel();
        if (level2 instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level2;
            Utils.scheduleTick(l, pos, (Block)this, 1);
        }
        super.onNeighborChange(state, level, pos, neighbor);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.getBlockState(pos.below()).is(Registry.ADVANCED_NOTEBLOCK)) {
            Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 8.0, true);
            if (!(player instanceof Player)) {
                level.destroyBlock(pos, false);
            } else {
                Player player2 = player;
                level.destroyBlock(pos, true, (Entity)player2);
            }
        }
        BREAK_DELAY.clear();
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        List<ItemStack> cores = List.of(new ItemStack((ItemLike)Registry.VOLUME.get()), new ItemStack((ItemLike)Registry.SUSTAIN.get()));
        boolean mixing = TuningCore.isMixing(state);
        boolean sustaining = TuningCore.isSustaining(state);
        Object object = params.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            Inventory inv = player.getInventory();
            int nugCount = inv.countItem(Items.IRON_NUGGET);
            if (mixing && sustaining && nugCount >= 2) {
                drops.addAll(cores);
            } else if (nugCount >= 1) {
                drops.add(mixing ? cores.getFirst() : cores.getLast());
            }
            Utils.removeItemsFromInventory(inv, Items.IRON_NUGGET, drops.size());
        } else {
            if (mixing) {
                drops.add(cores.getFirst());
            }
            if (sustaining) {
                drops.add(cores.getLast());
            }
        }
        return drops;
    }

    public static boolean isSustaining(BlockState state) {
        return TuningCore.getSustain(state) != 0;
    }

    public static boolean isMixing(BlockState state) {
        return TuningCore.getVolume(state) != 0;
    }

    public static int getSustain(BlockState state) {
        return (Integer)state.getValue((Property)SUSTAIN);
    }

    public static int getVolume(BlockState state) {
        return (Integer)state.getValue((Property)VOLUME);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.IRON_NUGGET)) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (stack.getCount() >= 2) {
                level.destroyBlock(pos, !player.isCreative(), (Entity)player);
            } else if (!TuningCore.isSustaining(state) || !TuningCore.isMixing(state)) {
                level.destroyBlock(pos, !player.isCreative(), (Entity)player);
            } else {
                this.removeOneCore(state, level, pos, player, hand == InteractionHand.MAIN_HAND);
            }
            return InteractionResult.SUCCESS;
        }
        if (!stack.is(NBMTags.Items.TUNERS) && !stack.is(NBMTags.Items.CORES)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        BlockState anb = level.getBlockState(pos.below());
        if (!anb.is(Registry.ADVANCED_NOTEBLOCK)) {
            if (!level.isClientSide()) {
                level.scheduleTick(pos, state.getBlock(), 0);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            TuningCore.openCoreScreen(state, anb, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openCoreScreen(BlockState state, BlockState anb, BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new CoreScreen(state, pos, (AdvancedInstrument)((Object)anb.getValue(AdvancedNoteBlock.INSTRUMENT)), AdvancedNoteBlock.getPitchFromNote(AdvancedNoteBlock.getNoteValue(anb))));
    }

    protected void removeOneCore(BlockState state, Level level, BlockPos pos, Player player, boolean sustainFirst) {
        if (level.isClientSide()) {
            return;
        }
        boolean sus = TuningCore.isSustaining(state) && sustainFirst;
        level.setBlock(pos, (BlockState)state.setValue((Property)(sus ? SUSTAIN : VOLUME), (Comparable)Integer.valueOf(0)), 11);
        if (!player.isCreative()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)(sus ? new ItemStack((ItemLike)Registry.SUSTAIN.get()) : new ItemStack((ItemLike)Registry.VOLUME.get())));
            level.playSound(null, pos, CORE_SOUNDS.getBreakSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
            Utils.removeItemsFromInventory(player.getInventory(), Items.IRON_NUGGET, 1);
        }
        BREAK_DELAY.add(pos.immutable());
        level.scheduleTick(pos, state.getBlock(), 1);
    }

    static {
        POWERED = BlockStateProperties.POWERED;
        CORE_SOUNDS = new DeferredSoundType(1.0f, 1.0f, () -> SoundEvents.ENDER_EYE_DEATH, () -> SoundEvents.WOOD_STEP, () -> SoundEvents.ENDER_EYE_LAUNCH, () -> SoundEvents.WOOL_HIT, () -> SoundEvents.WOOD_FALL);
        COLLISION = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        BREAK_DELAY = new ArrayList<BlockPos>();
    }
}

