/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.network.data.SongID;
import net.nayrus.noteblockmaster.network.payload.ActionPing;
import net.nayrus.noteblockmaster.network.payload.LoadSong;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.setup.config.ClientConfig;
import net.nayrus.noteblockmaster.setup.config.StartupConfig;
import net.nayrus.noteblockmaster.utils.FinalTuple;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;

public class MainCommand {
    public static void mainCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nbm").then(MainCommand.saveConfigCommand())).then(MainCommand.lowResolutionCommand())).executes(context -> -1));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> saveConfigCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"saveconfig").executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                if (!StartupConfig.UPDATED) {
                    StartupConfig.updateStartUpAndSave();
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"text.config.updated").withColor(Color.GREEN.darker().getRGB()), true);
                }
            } else {
                ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = patt0$temp;
                    ActionPing.sendActionPing(player, ActionPing.Action.SAVE_STARTUP_CONFIG);
                }
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> lowResolutionCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"improveFPS").then(Commands.argument((String)"activate", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                boolean activate = BoolArgumentType.getBool((CommandContext)context, (String)"activate");
                if ((Boolean)ClientConfig.LOW_RESOLUTION_RENDER.get() != activate) {
                    ClientConfig.LOW_RESOLUTION_RENDER.set((Object)activate);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)(activate ? "text.lowres.enable" : "text.lowres.disable")), true);
                    ClientConfig.CLIENT.save();
                }
            } else {
                ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = patt0$temp;
                    ActionPing.sendActionPing(player, BoolArgumentType.getBool((CommandContext)context, (String)"activate") ? ActionPing.Action.ACTIVATE_LOW_RES_RENDER : ActionPing.Action.DEACTIVATE_LOW_RES_RENDER);
                }
            }
            return 1;
        }))).executes(context -> {
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                if (ClientConfig.LOW_RESOLUTION_RENDER.isFalse()) {
                    ClientConfig.LOW_RESOLUTION_RENDER.set((Object)true);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"text.lowres.enable"), true);
                    ClientConfig.CLIENT.save();
                } else {
                    ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer player = patt0$temp;
                        ActionPing.sendActionPing(player, ActionPing.Action.ACTIVATE_LOW_RES_RENDER);
                    }
                }
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> songCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"songs").then(MainCommand.loadSongCommand())).then(MainCommand.pushSongCommand())).then(MainCommand.dropSongCommand())).then(MainCommand.applySongCommand())).then(MainCommand.listAvailableSongsCommand())).then(MainCommand.listCachedSongsCommand());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> loadSongCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"load").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            if (((CommandSourceStack)context.getSource()).isPlayer()) {
                String songName = StringArgumentType.getString((CommandContext)context, (String)"name");
                PacketDistributor.sendToPlayer((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayerOrException(), (CustomPacketPayload)new LoadSong(songName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return 1;
            }
            return -1;
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> pushSongCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"push").then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            if (!((CommandSourceStack)context.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID id = UuidArgument.getUuid((CommandContext)context, (String)"UUID");
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SongCache.PushRequest(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> dropSongCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            if (!((CommandSourceStack)context.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID id = UuidArgument.getUuid((CommandContext)context, (String)"UUID");
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SongCache.DropRequest(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        }))).then(Commands.literal((String)"fromNetwork").then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            UUID id = UuidArgument.getUuid((CommandContext)context, (String)"UUID");
            SongCache.SERVER_CACHE.dropSong(id);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SongCache.DropRequest(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 1;
        })))).then(Commands.literal((String)"fromServer").then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            UUID id = UuidArgument.getUuid((CommandContext)context, (String)"UUID");
            SongCache.SERVER_CACHE.dropSong(id);
            return 1;
        })));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> applySongCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"apply").then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
            if (((CommandSourceStack)context.getSource()).isPlayer()) {
                ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
                ItemStack composition = FinalTuple.getHeldItems((Player)player).getFirst((Item)Registry.COMPOSITION.get());
                if (composition.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Unable to write Song ID onto invalid ItemStack"));
                    return 1;
                }
                SongID songID = new SongID(UuidArgument.getUuid((CommandContext)context, (String)"UUID"));
                composition.set(Registry.SONG_ID, (Object)songID);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)songID, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return 1;
            }
            return -1;
        }));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> listCachedSongsCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"listCached").executes(context -> {
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                if (((CommandSourceStack)context.getSource()).isPlayer()) {
                    ActionPing.sendActionPing(((CommandSourceStack)context.getSource()).getPlayerOrException(), ActionPing.Action.LIST_CLIENT_CACHE);
                } else {
                    for (String songInfo : SongCache.SERVER_CACHE.getCachedSongInfo()) {
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)songInfo));
                    }
                }
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"SERVER CACHE:"));
            for (String songInfo : SongCache.SERVER_CACHE.getCachedSongInfo()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("- " + songInfo.substring(40))).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, songInfo.substring(0, 36))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to copy UUID (" + songInfo.substring(0, 36) + ")"))))));
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"CLIENT CACHE:"));
            ActionPing.sendActionPing(((CommandSourceStack)context.getSource()).getPlayerOrException(), ActionPing.Action.LIST_CLIENT_CACHE);
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> listAvailableSongsCommand() {
        return (LiteralArgumentBuilder)Commands.literal((String)"listAvailable").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Available song IDs:"));
            for (String songID : SongCache.SERVER_CACHE.getRegisteredSongIDs()) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)songID));
            }
            return 1;
        });
    }
}

