/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.nayrus.noteblockmaster.composer.ComposerBlockEntity;
import net.nayrus.noteblockmaster.composer.ComposerContainer;
import net.nayrus.noteblockmaster.setup.Registry;
import net.nayrus.noteblockmaster.utils.Utils;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ComposerBlock
extends Block
implements EntityBlock {
    public ComposerBlock(ResourceLocation key) {
        super(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key)).sound(SoundType.WOOD).strength(1.0f).noOcclusion());
        this.registerDefaultState((BlockState)this.getStateDefinition().any());
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                this.attack(state, level, pos, player);
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        if (player.isShiftKeyDown()) {
            super.spawnDestroyParticles(level, player, pos, state);
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ComposerBlockEntity)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        ComposerBlockEntity BE = (ComposerBlockEntity)blockEntity;
        if (!level.isClientSide()) {
            if (!stack.is(Registry.COMPOSITION)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            ItemStack item = BE.getItem();
            float rotation = Utils.getAngleToBlock(pos, player);
            if (item.isEmpty()) {
                BE.setRotation(rotation);
                BE.setItem(stack);
                player.setItemInHand(hand, ItemStack.EMPTY);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ComposerBlockEntity.ClientItemUpdate(pos, Optional.of(stack), Optional.of(Float.valueOf(rotation))), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                int slot = player.getInventory().getFreeSlot();
                player.setItemInHand(hand, ItemStack.EMPTY);
                player.getInventory().add(slot, item);
                BE.setRotation(rotation);
                BE.setItem(stack);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ComposerBlockEntity.ClientItemUpdate(pos, Optional.of(stack), Optional.of(Float.valueOf(rotation))), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.is(Registry.COMPOSITION)) {
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(state.getMenuProvider(level, pos));
        }
        return InteractionResult.SUCCESS;
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        ComposerBlockEntity BE;
        ItemStack item;
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof ComposerBlockEntity && !(item = (BE = (ComposerBlockEntity)blockEntity).getItem()).isEmpty()) {
            ComposerBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)item);
            BE.clearItem();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ComposerBlockEntity.ClientItemUpdate(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.attack(state, level, pos, player);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ComposerBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ComposerBlockEntity)) {
            return null;
        }
        ComposerBlockEntity entity = (ComposerBlockEntity)blockEntity;
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new ComposerContainer(containerId, playerInventory, entity), (Component)Component.translatable((String)"menu.title.noteblockmaster.composer"));
    }
}

