/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.nayrus.noteblockmaster.composer.ComposerContainer;
import net.nayrus.noteblockmaster.setup.Registry;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ComposerBlockEntity
extends BaseContainerBlockEntity {
    private ItemStack item = ItemStack.EMPTY;
    private float rotation = 0.0f;

    public ComposerBlockEntity(BlockPos pos, BlockState blockState) {
        super(Registry.COMPOSER_BE.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.noteblockmaster.composer");
    }

    protected NonNullList<ItemStack> getItems() {
        return NonNullList.of((Object)this.item, (Object[])new ItemStack[0]);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack stack) {
        this.setItems((NonNullList<ItemStack>)NonNullList.of((Object)stack, (Object[])new ItemStack[]{stack}));
    }

    public void clearItem() {
        this.setItem(ItemStack.EMPTY);
        this.setRotation(0.0f);
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.item = (ItemStack)items.getFirst();
        this.setChanged();
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ComposerContainer(containerId, inventory, this);
    }

    public int getContainerSize() {
        return 1;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        CompoundTag item = tag.getCompound("Item");
        this.setRotation(tag.getFloat("ItemRotation"));
        this.setItem(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)item));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Item", this.getItem().saveOptional(registries));
        tag.putFloat("ItemRotation", this.getRotation());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
    }

    public static void handleClientItemUpdate(ClientItemUpdate packet, IPayloadContext context) {
        Player player = context.player();
        ClientLevel level = (ClientLevel)player.level();
        BlockEntity blockEntity = level.getBlockEntity(packet.pos());
        if (!(blockEntity instanceof ComposerBlockEntity)) {
            return;
        }
        ComposerBlockEntity BE = (ComposerBlockEntity)blockEntity;
        if (packet.item().isEmpty()) {
            BE.clearItem();
            player.level().playSound(player, packet.pos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS);
        } else {
            if (packet.rotation().isPresent()) {
                BE.setRotation(packet.rotation().get().floatValue());
            }
            BE.setItem(packet.item().get());
            player.level().playSound(player, packet.pos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS);
        }
    }

    public record ClientItemUpdate(BlockPos pos, Optional<ItemStack> item, Optional<Float> rotation) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientItemUpdate> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"noteblockmaster", (String)"itempayload"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ClientItemUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientItemUpdate::pos, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional), ClientItemUpdate::item, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), ClientItemUpdate::rotation, ClientItemUpdate::new);

        public ClientItemUpdate(BlockPos pos) {
            this(pos, Optional.empty(), Optional.empty());
        }

        public CustomPacketPayload.Type<ClientItemUpdate> type() {
            return TYPE;
        }
    }
}

