/*
 * Decompiled with CFR 0.152.
 */
package net.nayrus.noteblockmaster.composer;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.nayrus.noteblockmaster.composer.ComposerBlockEntity;
import net.nayrus.noteblockmaster.composer.SongCache;
import net.nayrus.noteblockmaster.composer.SongData;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class ComposerNetwork {
    public static final ConcurrentHashMap<UUID, CompletableFuture<SongData>> pullRequests = new ConcurrentHashMap();

    public static void register(PayloadRegistrar reg) {
        reg.playToClient(ComposerBlockEntity.ClientItemUpdate.TYPE, ComposerBlockEntity.ClientItemUpdate.STREAM_CODEC, ComposerBlockEntity::handleClientItemUpdate);
        reg.executesOn(HandlerThread.NETWORK);
        reg.playToClient(SongCache.PushRequest.TYPE, SongCache.PushRequest.STREAM_CODEC, SongCache::handlePushRequest);
        reg.playToClient(SongCache.DropRequest.TYPE, SongCache.DropRequest.STREAM_CODEC, SongCache::handleDropRequest);
        reg.playBidirectional(SongData.TYPE, SongData.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ComposerNetwork::handleSongPull, ComposerNetwork::handleSongPush));
        reg.playBidirectional(SongCache.KeyCheck.TYPE, SongCache.KeyCheck.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(SongCache::handleKeyCheckOnClient, SongCache::handleKeyCheckOnServer));
        reg.playToServer(SongCache.PullRequest.TYPE, SongCache.PullRequest.STREAM_CODEC, SongCache::handlePullRequest);
    }

    private static void handleSongPush(SongData data, IPayloadContext context) {
        SongCache.cacheSong(data.getID(), data, SongCache.SERVER_CACHE);
    }

    private static void handleSongPull(SongData data, IPayloadContext context) {
        UUID id = data.getID();
        pullRequests.computeIfPresent(id, (uuid, future) -> {
            future.complete(data);
            return null;
        });
        SongCache.cacheSong(id, data);
    }
}

